/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.index.IInternalNetworkIndex;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexNotifyAvailable;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CNetworkIndexApiTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNetworkIndexApiTarget.class);
    private static final String FILTER = "nid=TRANSPORT";
    private IInternalNetworkIndex mInternalNetworkIndex;
    private INamespace mNamespace;
    private IRecordHelper mRecordHelper;

    CNetworkIndexApiTarget() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespace.class, FILTER);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(IInternalNetworkIndex.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mInternalNetworkIndex = (IInternalNetworkIndex)aServiceRegistry.getService(IInternalNetworkIndex.class);
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getService(IRecordHelper.class);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkIndexNotifyAvailable.ID, this::asyncNotifyNetworkIndexAvailable);
        this.mNamespace = (INamespace)aServiceRegistry.getService(INamespace.class, FILTER);
        this.mNamespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    private boolean asyncNotifyNetworkIndexAvailable(CEnvelope aEnvelope, CRecord aRecord) {
        boolean available = CRecordNetworkIndexNotifyAvailable.getAvailable((CRecord)aRecord, (boolean)false);
        CTargetAddress address = CRecordNetworkIndexNotifyAvailable.getAddress((CRecord)aRecord, null);
        if (available) {
            this.mInternalNetworkIndex.registerNetworkIndex(address);
            LOG.debug("Network Index {} available", new Object[]{address});
        } else {
            this.mInternalNetworkIndex.deregisterNetworkIndex(address);
            LOG.debug("Network Index {} not available", new Object[]{address});
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        this.mInternalNetworkIndex.setTarget((ITarget)this);
        this.mRecordHelper.addObserver(CRecordNetworkIndexNotifyAvailable.class, (ITarget)this, true);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mInternalNetworkIndex.setTarget(null);
        this.mRecordHelper.removeObserver(CRecordNetworkIndexNotifyAvailable.class, (ITarget)this);
        INanoServiceRegistry sr = this.mNamespace.getNanoServiceRegistry();
        if (sr != null) {
            sr.removeObserver(CRecordNetworkIndexNotifyAvailable.ID, this.getAddress());
        }
        this.deregisterTarget();
    }
}

