/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.connection.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.network.connection.registry.CConnectionEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CConnectionEntryList {
    private static final ILogger LOG_CONNECTIONS = CLoggerFactory.getLogger((String)"network.connections");
    private final Map<UUID, CConnectionEntry> mConnectionMap = new HashMap<UUID, CConnectionEntry>(10);

    CConnectionEntryList() {
    }

    void add(@NotNull CConnectionEntry aDto) {
        UUID id = aDto.getConnection().getID();
        CUtilCheck.checkNotNull((Object)id, (String)"Connection ID is missing", (Object[])new Object[0]);
        this.mConnectionMap.put(id, aDto);
        this.dump();
    }

    CConnectionEntry findNodeIdWithDifferentInstanceId(CNodeAddress aNode, UUID aInstanceId) {
        CConnectionEntry result = null;
        for (CConnectionEntry e : this.mConnectionMap.values()) {
            UUID instanceID = e.getConnection().getRemoteInstanceID();
            CNodeAddress node = e.getConnection().getRemoteNodeAddress();
            if (node == null || !node.equals((Object)aNode) || instanceID == null || instanceID.equals(aInstanceId)) continue;
            result = e;
            break;
        }
        return result;
    }

    @Nullable
    CConnectionEntry get(@NotNull UUID aId) {
        return this.mConnectionMap.get(aId);
    }

    Collection<UUID> getConnectionList() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (CConnectionEntry e : this.mConnectionMap.values()) {
            list.add(e.getConnection().getID());
        }
        return list;
    }

    Collection<CConnectionEntry> getEntriesForNode(CNodeAddress aNode) {
        ArrayList<CConnectionEntry> entries = new ArrayList<CConnectionEntry>();
        for (CConnectionEntry e : this.mConnectionMap.values()) {
            CNodeAddress adr = e.getConnection().getRemoteNodeAddress();
            if (e.isStopped() || adr == null || !adr.equals((Object)aNode)) continue;
            entries.add(e);
        }
        return entries;
    }

    Collection<CNodeAddress> getNeighborNodes() {
        HashSet<CNodeAddress> nodes = new HashSet<CNodeAddress>();
        for (CConnectionEntry e : this.mConnectionMap.values()) {
            CNodeAddress node = e.getConnection().getRemoteNodeAddress();
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Nullable
    CConnectionEntry remove(@NotNull UUID aId) {
        CConnectionEntry removed = this.mConnectionMap.remove(aId);
        if (removed != null) {
            this.dump();
        }
        return removed;
    }

    int size() {
        return this.mConnectionMap.size();
    }

    CConnectionEntry findNode(@NotNull CNodeAddress aNodeAddress) {
        for (CConnectionEntry value : this.mConnectionMap.values()) {
            if (!aNodeAddress.equals((Object)value.getConnection().getRemoteNodeAddress())) continue;
            return value;
        }
        return null;
    }

    CConnectionEntry getEntryForNode(@NotNull CNodeAddress aNode) {
        CConnectionEntry result = null;
        long startTime = 0L;
        Collection<CConnectionEntry> ee = this.getEntriesForNode(aNode);
        for (CConnectionEntry e : ee) {
            long startTime1 = e.getStartTime();
            if (startTime1 <= startTime) continue;
            result = e;
            startTime = startTime1;
        }
        return result;
    }

    @Nullable
    CConnectionEntry findConnection(@NotNull CNodeAddress aRemoteNodeAddress, @NotNull UUID aRemoteInstanceID) {
        for (CConnectionEntry e : this.mConnectionMap.values()) {
            CConnectionDto connection = e.getConnection();
            CNodeAddress remoteNodeAddress = connection.getRemoteNodeAddress();
            UUID remoteInstanceID = connection.getRemoteInstanceID();
            if (!aRemoteInstanceID.equals(remoteInstanceID) || !aRemoteNodeAddress.equals((Object)remoteNodeAddress)) continue;
            return e;
        }
        return null;
    }

    @NotNull
    String printConnectionTable() {
        StringBuilder sb = new StringBuilder(this.size() * 120);
        sb.append(CUtilString.LINE_CRLF);
        sb.append("Connections:\n");
        sb.append("ID      LocalAddress         RemoteAddress        NodeAddress                              InstanceId                           TimeStarted\n");
        for (UUID id : this.getConnectionList()) {
            CConnectionEntry entry = this.get(id);
            if (entry == null) continue;
            CConnectionDto c = entry.getConnection();
            sb.append(String.format("%-7.7s", CUtilUuid.toShortString((UUID)c.getID())));
            sb.append(String.format(" %-20.20s", c.getLocalAddress()));
            sb.append(String.format(" %-20.20s", c.getRemoteAddress()));
            sb.append(String.format(" %-40.40s", c.getRemoteNodeAddress()));
            sb.append(String.format(" %s", c.getRemoteInstanceID()));
            sb.append(String.format(" %s", c.getTimeStarted()));
            sb.append("\n");
        }
        sb.append(CUtilString.LINE);
        return sb.toString();
    }

    private void dump() {
        if (LOG_CONNECTIONS.isDebugEnabled()) {
            LOG_CONNECTIONS.debug(this.printConnectionTable());
        }
    }
}

