/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.socket;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.socket.CWebSocketServer;
import de.sillysky.nyssr.impl.web.socket.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Objects;
import java.util.prefs.Preferences;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.jetbrains.annotations.NotNull;

class CWebSocketServerTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWebSocketServerTarget.class);
    private CWebSocketServer mServer;
    private final IDependencies mDependencies;
    private final Path mKeystorePath;
    private final String mKeystorePassword;

    CWebSocketServerTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        IKernelConfiguration ks = this.mDependencies.getKernelConfiguration();
        Preferences preferences = ks.getPreferences("webserver.ssl");
        String p = preferences.get("path.keystore", "");
        this.mKeystorePath = Objects.requireNonNull(ks.getStoragePath()).resolve(p);
        this.mKeystorePassword = preferences.get("password.keystore", "");
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespaceFactory nf = this.mDependencies.getNamespaceFactory();
        IId nid = CIdFactory.fromObject((Object)"WebSocketServer");
        INamespace ns = nf.createAndRegisterNamespace(nid, "WebSocketServer");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws InterruptedException {
        this.mServer.stop();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mServer = new CWebSocketServer((ITarget)this, this.mDependencies, 8087);
        this.mServer.start();
        LOG.info("WebSocketServer started on port: " + this.mServer.getPort());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws Exception {
        this.mServer = new CWebSocketServer((ITarget)this, this.mDependencies, 8087);
        String STORETYPE = "JKS";
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(Files.newInputStream(this.mKeystorePath, new OpenOption[0]), this.mKeystorePassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, this.mKeystorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ks);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        this.mServer.setWebSocketFactory(new DefaultSSLWebSocketServerFactory(sslContext));
        this.mServer.start();
        LOG.info("WebSocketServer started on port: " + this.mServer.getPort());
        aEnvelope.setResultSuccess();
        return true;
    }
}

