/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.socket;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.factory.collector.CConstantsAppFactoryCollector;
import de.sillysky.nyssr.app.factory.collector.records.CRecordLaunchApplication;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.store.api.EFileDeliveryType;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.web.socket.CWidgetSetProviderList;
import de.sillysky.nyssr.impl.web.socket.IDependencies;
import de.sillysky.nyssr.impl.web.socket.IWebSocketConnection;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonStringArray;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddClassesToElement;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddCssRules;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddScript;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddStyleSheet;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAddTableRowListener;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebAlert;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebDeregisterWidgetOwner;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebIncomingJson;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebListenOnClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebListenOnClick2;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebLoadImage;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyTableRowClicked;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebOpenNewTab;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRegisterWidgetOwner;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveClassesFromElement;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveElement;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveElementIds;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveScript;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebRemoveStyleSheet;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebSendJson;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebSetInnerHtml;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebSetStylesForElements;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebSetValue;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebShowModal;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebUikitAlert;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CWebSocketConnection
extends CTarget
implements IWebSocketConnection {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWebSocketConnection.class);
    private final WebSocket mSocket;
    private final CWidgetSetProviderList mWidgetSetProviderList = new CWidgetSetProviderList();
    private final CResult mResultClosed = new CResult(4, "WebSocket closed");
    private final Map<String, Set<String>> mImageMap = new HashMap<String, Set<String>>();
    @NotNull
    private final IDependencies mDependencies;
    private final Path mWebRoot;
    private final Path mAssets;
    private String mApplicationId;
    private String mSessionToken;

    CWebSocketConnection(@NotNull IDependencies aDependencies, @NotNull WebSocket aSocket, @NotNull ClientHandshake aHandshake) throws CException {
        this.mSocket = aSocket;
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebRegisterWidgetOwner.ID, this::asyncWebRegisterWidgetOwner);
        this.addMessageHandler(CRecordWebDeregisterWidgetOwner.ID, this::asyncWebDeregisterWidgetOwner);
        this.addMessageHandler(CRecordWebRemoveElementIds.ID, this::asyncWebRemoveElementIds);
        this.addMessageHandler(CRecordWebAddCssRules.ID, this::asyncWebAddCssRules);
        this.addMessageHandler(CRecordWebSetInnerHtml.ID, this::asyncWebSetInnerHtml);
        this.addMessageHandler(CRecordWebListenOnClick1.ID, this::asyncWebListenOnClick1);
        this.addMessageHandler(CRecordWebListenOnClick2.ID, this::asyncWebListenOnClick2);
        this.addMessageHandler(CRecordWebAddStyleSheet.ID, this::asyncWebAddStyleSheet);
        this.addMessageHandler(CRecordWebRemoveStyleSheet.ID, this::asyncWebRemoveStyleSheet);
        this.addMessageHandler(CRecordLaunchApplication.ID, this::asyncLaunchApplication);
        this.addMessageHandler(CRecordWebOpenNewTab.ID, this::asyncWebOpenNewTab);
        this.addMessageHandler(CRecordWebAddTableRowListener.ID, this::asyncWebAddTableRowListener);
        this.addMessageHandler(CRecordWebAddClassesToElement.ID, this::asyncWebAddClassesToElement);
        this.addMessageHandler(CRecordWebRemoveClassesFromElement.ID, this::asyncWebRemoveClassesFromElement);
        this.addMessageHandler(CRecordWebShowModal.ID, this::asyncWebShowModal);
        this.addMessageHandler(CRecordWebSetValue.ID, this::asyncWebSetValue);
        this.addMessageHandler(CRecordWebRemoveElement.ID, this::asyncWebRemoveElement);
        this.addMessageHandler(CRecordWebAlert.ID, this::asyncWebAlert);
        this.addMessageHandler(CRecordWebUikitAlert.ID, this::asyncWebUikitAlert);
        this.addMessageHandler(CRecordWebSetStylesForElements.ID, this::asyncWebSetStylesForElements);
        this.addMessageHandler(CRecordWebLoadImage.ID, this::asyncWebLoadImage);
        this.addMessageHandler(CRecordFileStoreRequestFile.ID, this::asyncRequestFile);
        this.addMessageHandler(CRecordWebSendJson.ID, this::asyncWebSendJson);
        this.addMessageHandler(CRecordWebAddScript.ID, this::asyncWebAddScript);
        this.addMessageHandler(CRecordWebRemoveScript.ID, this::asyncWebRemoveScript);
        this.mWebRoot = this.getWebRoot();
        this.mAssets = this.mWebRoot.resolve("assets");
        CUtilFile.createDirectories((Path)this.mAssets);
    }

    private Path getWebRoot() throws CException {
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Path storagePath = kc.getStoragePath();
        if (storagePath == null) {
            throw new CException(2202).append("No web root found");
        }
        Preferences preferences = kc.getPreferences("webserver");
        String webroot = preferences.get("webroot", "");
        if (webroot.indexOf(47) < 0 && webroot.indexOf(92) < 0) {
            return storagePath.resolve(webroot);
        }
        return Paths.get(webroot, new String[0]);
    }

    public void deactivate() {
        LOG.info("WebSocketConnection stopped: " + this.getAddress());
        this.mWidgetSetProviderList.stopTargets((ITarget)this);
        this.deregisterTarget();
    }

    @Override
    public boolean isRunning() {
        return this.mSocket != null && this.mSocket.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.mSocket == null || this.mSocket.isClosed();
    }

    void onMessage(@NotNull String aMessage) {
        LOG.info("Message from Browser: {}", new Object[]{aMessage});
        try {
            CJsonObject jo = this.mDependencies.getJsonParser().parse(aMessage, false);
            Object cmd = jo.getValue("cmd");
            if (cmd instanceof String) {
                switch ((String)cmd) {
                    case "info": {
                        this.mSessionToken = CUtilJsonString.fromJson((CJsonObject)jo, (String)"sessionToken", (String)"");
                        this.mApplicationId = CUtilJsonString.fromJson((CJsonObject)jo, (String)"applicationId", (String)"");
                        this.startApp(this.mSessionToken, this.mApplicationId);
                        break;
                    }
                    case "onClick": {
                        String dialogId = CUtilJsonString.fromJson((CJsonObject)jo, (String)"id", (String)"");
                        CTargetAddress owner = this.mWidgetSetProviderList.getProviderForWidget(dialogId);
                        if (owner == null) {
                            LOG.error("No owner found for dialog id: {}", new Object[]{dialogId});
                            break;
                        }
                        CRecord record = CRecordWebNotifyClick1.create();
                        CRecordWebNotifyClick1.setId((CRecord)record, (String)dialogId);
                        Object o = jo.getValue("values");
                        if (o instanceof CJsonObject) {
                            CJsonObject values = (CJsonObject)o;
                            CStringProperties vv = new CStringProperties();
                            for (String widgetId : values.keys()) {
                                Object v = values.getValue(widgetId);
                                if (v instanceof CJsonArray) {
                                    CJsonArray jArr = (CJsonArray)v;
                                    List list = jArr.getStringList();
                                    if (list.isEmpty()) continue;
                                    vv.put(widgetId, CUtilStringArray.toString((Iterable)list));
                                    continue;
                                }
                                vv.put(widgetId, v == null ? "" : v.toString());
                            }
                            CRecordWebNotifyClick1.setValues((CRecord)record, (CStringProperties)vv);
                        }
                        CEnvelope envelope = CEnvelope.forSingleTarget((CTargetAddress)owner);
                        this.sendNotification(envelope, record);
                        break;
                    }
                    case "onClick2": 
                    case "linkClick": {
                        String id = CUtilJsonString.fromJson((CJsonObject)jo, (String)"id", (String)"");
                        String how = CUtilJsonString.fromJson((CJsonObject)jo, (String)"how", (String)"left");
                        CTargetAddress owner = this.mWidgetSetProviderList.getProviderForWidget(id);
                        if (owner == null) {
                            LOG.error("No owner found for id: {}", new Object[]{id});
                            break;
                        }
                        CRecord record = CRecordWebNotifyClick2.create();
                        CRecordWebNotifyClick2.setId((CRecord)record, (String)id);
                        CRecordWebNotifyClick2.setHow((CRecord)record, (String)how);
                        CEnvelope envelope = CEnvelope.forSingleTarget((CTargetAddress)owner);
                        this.sendNotification(envelope, record);
                        break;
                    }
                    case "onClickTableRow": {
                        String id = CUtilJsonString.fromJson((CJsonObject)jo, (String)"id", (String)"");
                        List data = CUtilJsonStringArray.fromJson((CJsonObject)jo, (String)"data");
                        CTargetAddress owner = this.mWidgetSetProviderList.getProviderForWidget(id);
                        if (owner == null) {
                            LOG.error("No owner found for id: {}", new Object[]{id});
                            break;
                        }
                        CRecord record = CRecordWebNotifyTableRowClicked.create();
                        CRecordWebNotifyTableRowClicked.setId((CRecord)record, (String)id);
                        CRecordWebNotifyTableRowClicked.setData((CRecord)record, (String[])data.toArray(new String[0]));
                        CEnvelope envelope = CEnvelope.forSingleTarget((CTargetAddress)owner);
                        this.sendNotification(envelope, record);
                        break;
                    }
                    default: {
                        String id = CUtilJsonString.fromJson((CJsonObject)jo, (String)"id", (String)"");
                        if (CUtilString.isEmpty((String)id)) {
                            LOG.debug("Got unknown json: {}", new Object[]{aMessage});
                            break;
                        }
                        CTargetAddress owner = this.mWidgetSetProviderList.getProviderForWidget(id);
                        if (owner == null) {
                            LOG.error("No owner found for id: {}", new Object[]{id});
                            break;
                        }
                        CRecord record = CRecordWebIncomingJson.create();
                        CRecordWebIncomingJson.setJson((CRecord)record, (String)aMessage);
                        CRecordWebIncomingJson.setId((CRecord)record, (String)id);
                        CEnvelope envelope = CEnvelope.forSingleTarget((CTargetAddress)owner);
                        this.sendNotification(envelope, record);
                        break;
                    }
                }
            }
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error on parsing message from web socket");
        }
    }

    private void startApp(@Nullable String aSessionToken, @Nullable String aAppId) throws CException {
        UUID appId = UUID.fromString(CUtilString.isEmpty((String)aAppId) ? "fdb5ba01-dbf9-4b47-8326-ef18ee6ef3ce" : aAppId);
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
        CRecord record = CRecordLaunchApplication.create();
        CRecordLaunchApplication.setApplicationId((CRecord)record, (UUID)appId);
        CRecordLaunchApplication.setRemoteSkinTarget((CRecord)record, (CTargetAddress)this.getAddress());
        if (CUtilString.isValid((String)this.mSessionToken)) {
            CRecordLaunchApplication.setSessionToken((CRecord)record, (String)aSessionToken);
        }
        this.sendRequest(env, record);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        LOG.info("WebSocketConnection started: " + this.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebRegisterWidgetOwner(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress providerAddress = aEnvelope.getSender();
        String[] widgetIds = CRecordWebRegisterWidgetOwner.getWidgetIds((CRecord)aRecord, null);
        if (widgetIds != null) {
            for (String widgetId : widgetIds) {
                this.mWidgetSetProviderList.addWidget(widgetId, providerAddress);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDeregisterWidgetOwner(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String[] widgetIds = CRecordWebDeregisterWidgetOwner.getWidgetIds((CRecord)aRecord, null);
        if (widgetIds != null) {
            for (String widgetId : widgetIds) {
                this.mWidgetSetProviderList.removeWidget(widgetId);
            }
        } else {
            this.mWidgetSetProviderList.removeProvider(aEnvelope.getSender());
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebRemoveElementIds(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String[] elementIds = CRecordWebRemoveElementIds.getElementIds((CRecord)aRecord, null);
        if (elementIds != null) {
            for (String id : elementIds) {
                this.mWidgetSetProviderList.removeWidget(id);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebAddCssRules(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String[] rules = CRecordWebAddCssRules.getRules((CRecord)aRecord, null);
            CJsonObject jo = new CJsonObject(true);
            jo.put("cmd", (Object)"insertStyleRules");
            CJsonArray css = new CJsonArray();
            for (String rule : rules) {
                css.add((Object)rule);
            }
            jo.put("css", (Object)css);
            this.sendJson(jo);
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebSetInnerHtml(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebSetInnerHtml.getId((CRecord)aRecord, (String)"");
            String html = CRecordWebSetInnerHtml.getHtml((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(true);
            jo.put("cmd", (Object)"setInnerHtml");
            jo.put("id", (Object)id);
            jo.put("html", (Object)html);
            this.sendJson(jo);
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebAddTableRowListener(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebAddTableRowListener.getId((CRecord)aRecord, (String)"");
            this.mWidgetSetProviderList.addWidget(id, aEnvelope.getSender());
            CJsonObject jo = new CJsonObject(true);
            jo.put("cmd", (Object)"addTableRowEventListener");
            jo.put("id", (Object)id);
            this.sendJson(jo);
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebListenOnClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebListenOnClick1.getId((CRecord)aRecord, (String)"");
            this.mWidgetSetProviderList.addWidget(id, aEnvelope.getSender());
            String[] widgetIds = CRecordWebListenOnClick1.getWidgetIds((CRecord)aRecord, null);
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"listenOnClick1");
            jo.put("id", (Object)id);
            CJsonArray arr = new CJsonArray(widgetIds);
            jo.put("widgetIds", (Object)arr);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebListenOnClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            ArrayList<String> dartIds = new ArrayList<String>();
            String[] ids = CRecordWebListenOnClick2.getIds((CRecord)aRecord, null);
            CUtilCheck.checkNotNullEx((Object)ids, (String)"Missing ids.", (Object[])new Object[0]);
            for (String id : ids) {
                dartIds.add(id);
                this.mWidgetSetProviderList.addWidget(id, aEnvelope.getSender());
            }
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"listenOnClick2");
            CJsonArray arr = new CJsonArray(dartIds);
            jo.put("ids", (Object)arr);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebOpenNewTab(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            boolean sameUrl = CRecordWebOpenNewTab.getSameUrl((CRecord)aRecord, (boolean)true);
            String url = CRecordWebOpenNewTab.getUrl((CRecord)aRecord, (String)"");
            CStringProperties parameter = CRecordWebOpenNewTab.getParameter((CRecord)aRecord, null);
            if (!sameUrl) {
                CUtilCheck.checkEmptyStringEx((Object)url, (String)"Missing URL.", (Object[])new Object[0]);
            }
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"openNewTab");
            jo.put("sameUrl", (Object)sameUrl);
            if (parameter != null && !parameter.isEmpty()) {
                CJsonObject param = new CJsonObject(false);
                for (String key : parameter.getKeys()) {
                    param.put(key, (Object)parameter.get(key));
                }
                jo.put("parameters", (Object)param);
            }
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebAddStyleSheet(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebAddStyleSheet.getId((CRecord)aRecord, (String)"");
            String content = CRecordWebAddStyleSheet.getContent((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"addStyleSheet");
            jo.put("id", (Object)id);
            jo.put("content", (Object)content);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebRemoveStyleSheet(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebAddStyleSheet.getId((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"removeStyleSheet");
            jo.put("id", (Object)id);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncLaunchApplication(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            UUID applicationId = CRecordLaunchApplication.getApplicationId((CRecord)aRecord, null);
            if (aEnvelope.getResultCode() == 0) {
                CTargetAddress instanceAddress = CRecordLaunchApplication.getInstanceAddress((CRecord)aRecord, null);
                LOG.info("Application launched: {} on {}", new Object[]{applicationId, instanceAddress});
            } else {
                LOG.error("Launching app {} failed: {}", new Object[]{applicationId, aEnvelope.getResult()});
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebAddClassesToElement(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String[] clazzes;
            ArrayList<String> cc = new ArrayList<String>();
            String selector = CRecordWebAddClassesToElement.getSelector((CRecord)aRecord, (String)"");
            String clazz = CRecordWebAddClassesToElement.getClass((CRecord)aRecord, null);
            if (clazz != null) {
                cc.add(clazz);
            }
            if ((clazzes = CRecordWebAddClassesToElement.getClasses((CRecord)aRecord, null)) != null) {
                cc.addAll(Arrays.asList(clazzes));
            }
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"addElementClasses");
            jo.put("selector", (Object)selector);
            jo.put("classes", (Object)new CJsonArray(cc));
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebRemoveClassesFromElement(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String[] clazzes;
            ArrayList<String> cc = new ArrayList<String>();
            String selector = CRecordWebRemoveClassesFromElement.getSelector((CRecord)aRecord, (String)"");
            String clazz = CRecordWebRemoveClassesFromElement.getClass((CRecord)aRecord, null);
            if (clazz != null) {
                cc.add(clazz);
            }
            if ((clazzes = CRecordWebRemoveClassesFromElement.getClasses((CRecord)aRecord, null)) != null) {
                cc.addAll(Arrays.asList(clazzes));
            }
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"removeElementClasses");
            jo.put("selector", (Object)selector);
            jo.put("classes", (Object)new CJsonArray(cc));
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebShowModal(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebShowModal.getId((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"showModal");
            jo.put("id", (Object)id);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebAlert(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String message = CRecordWebAlert.getMessage((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"alert");
            jo.put("message", (Object)message);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebUikitAlert(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String message = CRecordWebUikitAlert.getMessage((CRecord)aRecord, (String)"");
            CStringProperties options = CRecordWebUikitAlert.getOptions((CRecord)aRecord, null);
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"uikitAlert");
            jo.put("message", (Object)message);
            if (options != null && !options.isEmpty()) {
                CJsonObject param = new CJsonObject(false);
                for (String key : options.getKeys()) {
                    param.put(key, (Object)options.get(key));
                }
                jo.put("options", (Object)param);
            }
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebSetStylesForElements(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String selector = CRecordWebSetStylesForElements.getSelector((CRecord)aRecord, (String)"");
            CUtilCheck.checkEmptyString((Object)selector, (String)"Missing selector", (Object[])new Object[0]);
            CStringProperties styles = CRecordWebSetStylesForElements.getStyles((CRecord)aRecord, null);
            CUtilCheck.checkNotNull((Object)styles, (String)"Missing styles", (Object[])new Object[0]);
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"setStylesForElements");
            jo.put("selector", (Object)selector);
            if (!styles.isEmpty()) {
                CJsonObject param = new CJsonObject(false);
                for (String key : styles.getKeys()) {
                    param.put(key, (Object)styles.get(key));
                }
                jo.put("styles", (Object)param);
            }
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebSetValue(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebSetValue.getId((CRecord)aRecord, (String)"");
            String value = CRecordWebSetValue.getValue((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"setValue");
            jo.put("id", (Object)id);
            jo.put("value", (Object)value);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebRemoveElement(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebRemoveElement.getId((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"removeElement");
            jo.put("id", (Object)id);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebLoadImage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String relativePath = CRecordWebLoadImage.getRelativePath((CRecord)aRecord, null);
        String elementId = CRecordWebLoadImage.getElementId((CRecord)aRecord, null);
        if (CUtilString.isValid((String)relativePath)) {
            if (CUtilString.isValid((String)elementId)) {
                Set elementIds = this.mImageMap.computeIfAbsent(relativePath, k -> new HashSet());
                elementIds.add(elementId);
            }
            this.sendRequestFile(relativePath);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRequestFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, IOException {
        if (aEnvelope.isAnswer()) {
            File file;
            String path;
            Set<String> elements;
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0 && (elements = this.mImageMap.get(path = CRecordFileStoreRequestFile.getPath((CRecord)aRecord, (String)""))) != null && this.isRunning() && (file = (File)CRecordFileStoreRequestFile.getFile((CRecord)aRecord, null)) != null) {
                Path pathRelativeToWebRoot = this.mAssets.resolve(path);
                CUtilFile.copyFile((Path)file.toPath(), (Path)pathRelativeToWebRoot, (boolean)true);
                for (String element : elements) {
                    CJsonObject jo = new CJsonObject(false);
                    jo.put("cmd", (Object)"setImage");
                    jo.put("id", (Object)element);
                    jo.put("src", (Object)("assets/" + path));
                    this.sendJson(jo);
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebSendJson(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String json = CRecordWebSendJson.getJson((CRecord)aRecord, (String)"");
            if (CUtilString.isValid((String)json)) {
                this.mSocket.send(json);
            }
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebAddScript(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebAddScript.getId((CRecord)aRecord, (String)"");
            String content = CRecordWebAddScript.getContent((CRecord)aRecord, null);
            String src = CRecordWebAddScript.getSrc((CRecord)aRecord, null);
            String onLoad = CRecordWebAddScript.getOnLoad((CRecord)aRecord, null);
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"addScript");
            jo.put("id", (Object)id);
            if (content != null) {
                jo.put("content", (Object)content);
            }
            if (src != null) {
                jo.put("src", (Object)src);
            }
            if (onLoad != null) {
                jo.put("onLoad", (Object)onLoad);
            }
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private boolean asyncWebRemoveScript(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.isRunning()) {
            String id = CRecordWebRemoveScript.getId((CRecord)aRecord, (String)"");
            CJsonObject jo = new CJsonObject(false);
            jo.put("cmd", (Object)"removeScript");
            jo.put("id", (Object)id);
            this.sendJson(jo);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(this.mResultClosed);
        }
        return true;
    }

    private void sendRequestFile(@NotNull String aRelativePath) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordFileStoreRequestFile.create();
        CRecordFileStoreRequestFile.setPath((CRecord)record, (String)aRelativePath);
        CRecordFileStoreRequestFile.setDeliveryType((CRecord)record, (byte)EFileDeliveryType.FILE.getType());
        this.sendRequest(env, record);
    }

    private void sendJson(@NotNull CJsonObject aJsonObject) {
        StringBuilder sb = new StringBuilder();
        this.mDependencies.getJsonCompactWriter().write(sb, (Object)aJsonObject);
        String json = sb.toString();
        LOG.debug("Send to Browser: {}", new Object[]{json});
        this.mSocket.send(json);
    }
}

