/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.login;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionLogin;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebDeregisterWidgetOwner;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.hash.CUtilPassword;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.string.CUtilBase64;
import de.sillysky.nyssr.web.dialog.login.records.CRecordDismissWebLoginDialog;
import de.sillysky.nyssr.web.dialog.login.records.CRecordWebLoginFinished;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class C00100Login
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(C00100Login.class);
    private static final String USER_ID = "id_00100_userid";
    private static final String PASSWORD = "id_00100_password";
    private static final String BUTTON = "id_00100_sign_in";
    private static final String ID_00100_ALERT_MESSAGE = "id_00100_alert_message";
    private static final String[] WIDGET_IDS = new String[]{"#rs_c7d48ddb-bf81-4f7e-9898-063869b735ea", "id_00100_userid", "id_00100_password", "id_00100_sign_in"};
    private static final String STYLE_SHEET_ID = "NY_STYLE_SHEET_LOGIN_DLG";
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mParentWidgetId;
    private final String mUserId;
    private CWebApi mWebApi;

    C00100Login(@NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId, @NotNull String aUserId) {
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mParentWidgetId = aParentWidgetId;
        this.mUserId = aUserId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordDismissWebLoginDialog.ID, this::asyncDismissLoginDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordSessionLogin.ID, this::asyncSessionLogin);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebApi.registerWidgets(WIDGET_IDS);
        this.showLoginDialog("/html/00100_main.html");
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDismissLoginDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(null, 3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String s;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties properties = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)properties, (String)"Missing properties on onClick", (Object[])new Object[0]);
        String userId = properties.get(USER_ID, "");
        CUtilCheck.checkEmptyStringEx((Object)userId, (String)"Missing userId", (Object[])new Object[0]);
        String password = properties.get(PASSWORD, "");
        CUtilCheck.checkEmptyStringEx((Object)password, (String)"Missing password", (Object[])new Object[0]);
        if (password.startsWith("^") && (s = CUtilBase64.decodeString((String)password)) != null) {
            password = CUtilPassword.hashPassword((char[])s.toCharArray());
        }
        this.sendLogin(userId, password != null ? password : "");
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionLogin(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                LOG.info("LogIn successful");
                String token = CRecordSessionLogin.getToken((CRecord)aRecord, null);
                this.finish(token, 0);
            } else {
                LOG.info("Error on LogIn");
                this.showAlert("User unknown or wrong password");
            }
            return true;
        }
        return false;
    }

    private void showLoginDialog(@NotNull String aFileName) throws CException {
        String html = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)aFileName);
        this.mWebApi.setInnerHtml(this.mParentWidgetId, html);
        this.mWebApi.addCss(STYLE_SHEET_ID, CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00100.css"));
        this.mWebApi.addClickListener1(BUTTON, new String[]{USER_ID, PASSWORD});
    }

    private void sendLogin(@NotNull String aUserId, @NotNull String aPassword) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        CRecord record = CRecordSessionLogin.create();
        CRecordSessionLogin.setUserId((CRecord)record, (String)aUserId);
        CRecordSessionLogin.setPassword((CRecord)record, (String)aPassword);
        this.sendRequest(env, record);
    }

    private void sendDeregisterWidgetOwner(@NotNull CTargetAddress aAddress) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddress);
        CRecord record = CRecordWebDeregisterWidgetOwner.create();
        this.sendNotification(env, record);
    }

    private void sendFinished(@Nullable String aSessionToken, int aReason) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mOwnerTargetAddress);
        CRecord record = CRecordWebLoginFinished.create();
        if (aSessionToken != null) {
            CRecordWebLoginFinished.setSessionToken((CRecord)record, (String)aSessionToken);
        }
        CRecordWebLoginFinished.setReason((CRecord)record, (int)aReason);
        this.sendNotification(env, record);
    }

    private void showAlert(@NotNull String aMessage) throws CException {
        String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00100_alert.html");
        alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)aMessage);
        this.mWebApi.setInnerHtml(ID_00100_ALERT_MESSAGE, alert);
    }

    private void finish(String aSessionToken, int aReason) throws CException {
        this.mWebApi.removeCss(STYLE_SHEET_ID);
        this.sendDeregisterWidgetOwner(this.mClientTargetAddress);
        this.sendFinished(aSessionToken, aReason);
        this.deregisterTarget();
    }
}

