/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.net;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.software.updater.net.CFileReadRunnable;
import de.sillysky.nyssr.impl.software.updater.net.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CDirectoryWatcher {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDirectoryWatcher.class);
    private final AtomicBoolean mStop = new AtomicBoolean(false);
    private final Map<WatchKey, Path> mKeys = new HashMap<WatchKey, Path>();
    private final Set<Path> mProcessedPaths = new HashSet<Path>();
    private final WatchService mWatcher;
    private boolean mTrace = false;
    private final IDependencies mDependencies;
    private final Path mIncomingPath;
    private final CTargetAddress mAddress;

    public CDirectoryWatcher(@NotNull IDependencies aDependencies, @NotNull Path aIncomingPath, @NotNull CTargetAddress aAddress) throws IOException {
        this.mDependencies = aDependencies;
        this.mIncomingPath = aIncomingPath;
        this.mAddress = aAddress;
        this.mWatcher = FileSystems.getDefault().newWatchService();
        this.addDir(this.mIncomingPath);
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> aEvent) {
        return aEvent;
    }

    void addDir(Path aDir) throws IOException {
        this.readExistingFiles(aDir);
        try {
            this.register(aDir);
            this.mTrace = true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "IOException");
        }
    }

    private void handleFile(Path aPath) {
    }

    private void readExistingFiles(Path aPath) throws IOException {
        try (Stream<Path> stream = Files.list(aPath);){
            stream.forEach(this::handleFile);
        }
    }

    private void register(Path aDir) throws IOException {
        WatchKey key = aDir.register(this.mWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (this.mTrace) {
            Path prev = this.mKeys.get(key);
            if (prev == null) {
                LOG.trace("register: {}", new Object[]{aDir});
            } else if (!aDir.equals(prev)) {
                LOG.trace("update: {} -> {}", new Object[]{prev, aDir});
            }
        }
        this.mKeys.put(key, aDir);
    }

    private void run() {
        LOG.debug("Start directory watcher on {}.", new Object[]{this.mIncomingPath});
        while (!this.mStop.get()) {
            WatchKey key;
            try {
                key = this.mWatcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            Path dir = this.mKeys.get(key);
            if (dir == null) {
                LOG.error("WatchKey not recognized!!");
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    LOG.error("Overflow!");
                    continue;
                }
                WatchEvent ev = CDirectoryWatcher.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.processFile(child);
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this.mProcessedPaths.remove(child);
                LOG.info("File {} processed successfully", new Object[]{child});
            }
            boolean valid = key.reset();
            if (valid) continue;
            LOG.trace("remove key {}", new Object[]{key});
            this.mKeys.remove(key);
            if (!this.mKeys.isEmpty()) continue;
            break;
        }
        LOG.debug("Watcher for directory {} stopped.", new Object[]{this.mIncomingPath});
    }

    public void start() {
        Thread thread = new Thread(this::run);
        thread.start();
    }

    public void stop() {
        this.mStop.set(true);
    }

    private void processFile(@NotNull Path aPath) {
        boolean added;
        if (Files.isRegularFile(aPath, LinkOption.NOFOLLOW_LINKS) && (added = this.mProcessedPaths.add(aPath))) {
            Thread thread = new Thread(new CFileReadRunnable(this.mDependencies, aPath, this.mAddress));
            thread.start();
        }
    }
}

