/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.server.dialog.records;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordOpenDialog
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"041b8aa7-4457-459a-8a82-00f6b3bbea0d");
    public static final String NAME = "OpenDialog";
    public static final String DESCRIPTION = "Open a dialog.";
    public static final String SLOT_ADDRESS_FOR_DISPLAYING_MESSAGES = "1270006";
    public static final String SLOT_CLIENT_CONTEXT_ADDRESS = "1270003";
    public static final String SLOT_CLIENT_CONTEXT_ID = "1270002";
    public static final String SLOT_PARENT_WIDGET_ID = "1270005";
    public static final String SLOT_PLATFORM_TYPE = "1270004";
    public static final String SLOT_ROUTING_HINT = "1270007";
    public static final String SLOT_SESSION_TOKEN = "1270001";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getAddressForDisplayingMessages(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ADDRESS_FOR_DISPLAYING_MESSAGES);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static CTargetAddress getClientContextAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CLIENT_CONTEXT_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static IId getClientContextId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CLIENT_CONTEXT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CWidgetId getParentWidgetId(@NotNull CRecord aRecord, CWidgetId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PARENT_WIDGET_ID);
        if (slot == null) {
            return aDefault;
        }
        return (CWidgetId)slot.getValue();
    }

    public static String getPlatformType(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PLATFORM_TYPE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CNodeId getRoutingHint(@NotNull CRecord aRecord, CNodeId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ROUTING_HINT);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeId)slot.getValue();
    }

    public static String getSessionToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setAddressForDisplayingMessages(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_ADDRESS_FOR_DISPLAYING_MESSAGES, slot);
    }

    public static void setClientContextAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_CLIENT_CONTEXT_ADDRESS, slot);
    }

    public static void setClientContextId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_CLIENT_CONTEXT_ID, slot);
    }

    public static void setParentWidgetId(@NotNull CRecord aRecord, CWidgetId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.WIDGET_ID, (Object)aValue);
        aRecord.addSlot(SLOT_PARENT_WIDGET_ID, slot);
    }

    public static void setPlatformType(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PLATFORM_TYPE, slot);
    }

    public static void setRoutingHint(@NotNull CRecord aRecord, CNodeId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ID, (Object)aValue);
        aRecord.addSlot(SLOT_ROUTING_HINT, slot);
    }

    public static void setSessionToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SESSION_TOKEN, slot);
    }
}

