/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.dialogs.stringinput;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.remoteskin.server.dialogs.stringinput.CStringInputModel;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.model.localevents.CEventStringInputDialogResult;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IStringInputDialogListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CStringInputUi {
    private final CStringInputModel mModel;
    private IRemoteSkinServerContext mServerContext;
    private IWidgetApi mApi;
    private CWidgetSetId mWidgetSetId;
    private CWidgetId mDialog;
    private CWidgetId mPanelBackground;
    private CWidgetId mLabel;
    private CWidgetId mTextField;
    private CWidgetId mButtonOkay;

    public CStringInputUi(@NotNull CStringInputModel aModel) {
        this.mModel = aModel;
    }

    void start() throws CException {
        this.mServerContext = this.mModel.getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        this.pushJson();
        String instance = "1";
        this.mWidgetSetId = CWidgetSetId.create((String)"@500_StringInput", (String)"1");
        this.mDialog = this.mWidgetSetId.createWidgetId("#500_Dialog");
        this.mApi.addListener(this.mDialog, (IListener)((IWindowClosingListener)this::onWindowClosing));
        this.mPanelBackground = this.mWidgetSetId.createWidgetId("#500_PanelBackground");
        this.mLabel = this.mWidgetSetId.createWidgetId("#500_Label");
        this.mTextField = this.mWidgetSetId.createWidgetId("#500_TextField");
        this.mApi.addListener(this.mTextField, (IListener)((ITextChangeListener)this::onTextChange));
        this.mButtonOkay = this.mWidgetSetId.createWidgetId("#500_ButtonOkay");
        this.mApi.addListener(this.mButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        CWidgetId buttonCancel = this.mWidgetSetId.createWidgetId("#500_ButtonCancel");
        this.mApi.addListener(buttonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
    }

    private void pushJson() throws CException {
        ArrayList<String> jsonList = new ArrayList<String>();
        String json = CUtilJson.loadJson(this.getClass(), (String)"/json/500_StringInput.json");
        jsonList.add(json);
        this.mServerContext.pushWidgetSets(jsonList, null);
    }

    private void widgetSet500Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.mApi.setTitle(this.mDialog, this.mModel.getTitle());
        this.mApi.setText(this.mLabel, this.mModel.getMessage());
        this.mApi.setForegroundColor(this.mLabel, new CEventColor(this.mModel.getForegroundColor()));
        String text = this.mModel.getInitialInputValue();
        this.mApi.setText(this.mTextField, text);
        this.checkButtonOkay(text, false);
        this.mApi.setBackgroundColor(this.mPanelBackground, new CEventColor(this.mModel.getBackgroundColor()));
        this.mApi.pack(this.mDialog);
        CWidgetId parent = this.mModel.getParent();
        if (parent != null) {
            this.mApi.centerWidget(this.mDialog, parent);
        } else {
            this.mApi.centerWidgetOnScreen(this.mDialog);
        }
        this.mApi.setVisible(this.mDialog, true);
        this.update(true);
    }

    private void onTextChange(@NotNull CEventTextChangeNotification aEvent) {
        String text = aEvent.getText();
        this.mModel.setEnteredText(text);
        this.checkButtonOkay(text, true);
    }

    private void checkButtonOkay(@NotNull String aText, boolean aUpdate) {
        boolean valid = CUtilString.isValid((String)aText);
        if (valid != this.mModel.isButtonOkayEnabled()) {
            this.mModel.setButtonOkayEnabled(valid);
            this.mApi.setEnabled(this.mButtonOkay, valid);
            this.update(aUpdate);
        }
    }

    private void onWindowClosing(@NotNull CEventWindowNotification aEvent) {
        this.sendCloseDialog(true);
        this.informListeners("Cancel");
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) {
        this.sendCloseDialog(true);
        this.informListeners("Okay");
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.sendCloseDialog(true);
        this.informListeners("Cancel");
    }

    void applyNotification(CRecord aRecord) throws CException {
        this.mServerContext.applyNotification(aRecord);
    }

    void sendCloseDialog(boolean aUpdate) {
        this.mServerContext.unmountWidget(this.mDialog);
        this.update(aUpdate);
    }

    void mountDialog() {
        this.mServerContext.mountWidgetSet(this.mWidgetSetId, null, null, this::widgetSet500Mounted);
        this.update(true);
    }

    void update(boolean aDoUpdate) {
        if (aDoUpdate) {
            this.mServerContext.sendUpdate();
        }
    }

    private void informListeners(@NotNull String aButtonText) {
        List<IStringInputDialogListener> listeners = this.mModel.getListeners();
        if (!listeners.isEmpty()) {
            String enteredText = this.mModel.getEnteredText();
            String initialInputValue = this.mModel.getInitialInputValue();
            CEventStringInputDialogResult event = new CEventStringInputDialogResult(aButtonText, initialInputValue, enteredText);
            listeners.forEach(l -> {
                try {
                    l.notify(event);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            listeners.clear();
        }
    }
}

