/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.manager;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.IApplicationContext;
import de.sillysky.nyssr.app.IApplicationInstance;
import de.sillysky.nyssr.impl.app.manager.CApplicationManager;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CApplicationContext
implements IApplicationContext {
    private final IApplicationInstance mInstance;
    private final INamespace mNamespace;
    private CNodeAddress mClientRemoteSkinAddress;
    private CApplicationManager mApplicationManager;

    CApplicationContext(@NotNull CApplicationManager aApplicationManager, @NotNull IApplicationInstance aInstance, @Nullable INamespace aNamespace) {
        this.mApplicationManager = aApplicationManager;
        this.mInstance = aInstance;
        this.mNamespace = aNamespace;
    }

    void reset() {
        this.mApplicationManager = null;
    }

    public void exit(@Nullable CResult aResult) throws Exception {
        UUID instanceID = this.mInstance.getInstanceId();
        if (this.mApplicationManager != null && instanceID != null) {
            this.mApplicationManager.exit(instanceID, aResult);
        }
    }

    public UUID getInstanceId() {
        return this.mInstance.getInstanceId();
    }

    @Nullable
    public INamespace getNamespace() {
        return this.mNamespace;
    }

    @NotNull
    public String getPresetName() {
        return this.mInstance.getPresetName();
    }

    @NotNull
    public CStringProperties getProperties() {
        return this.mInstance.getPresetProperties();
    }

    public void setProperty(@NotNull String aKey, @Nullable String aValue) {
        UUID instanceID = this.mInstance.getInstanceId();
        if (instanceID != null) {
            this.mApplicationManager.setProperty(instanceID, aKey, aValue);
        }
    }

    public void setTargetAddress(@Nullable CTargetAddress aAddress) {
        this.mApplicationManager.setInstanceTargetAddress(this.mInstance.getInstanceId(), aAddress);
    }

    public String getSessionToken() {
        return this.mInstance.getSessionToken();
    }

    @Nullable
    public CNodeAddress getClientRemoteSkinAddress() {
        return this.mClientRemoteSkinAddress;
    }

    public void setClientRemoteSkinAddress(@Nullable CNodeAddress aClientRemoteSkinAddress) {
        this.mClientRemoteSkinAddress = aClientRemoteSkinAddress;
    }
}

