/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.test;

import de.sillysky.nyssr.app.CApplicationDescription;
import de.sillysky.nyssr.app.IApplication;
import de.sillysky.nyssr.app.IApplicationContext;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.UUID;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

final class CTestApp
extends CTarget
implements IApplication {
    static final CApplicationDescription mDesc = new CApplicationDescription(UUID.fromString("0c6d4164-a1a3-4df9-a8f9-985d37f07f76"));
    private IApplicationContext mContext;
    private INameDb mNameDb;

    CTestApp() {
    }

    void activate(INameDb aNameDb) {
        this.mNameDb = aNameDb;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) {
        this.mNameDb.getTargetAddressDatabase().putName(this.getAddress(), "TestApp_" + CUtilUuid.toShortString((UUID)this.mContext.getInstanceId()));
        JOptionPane.showMessageDialog(null, "Test App started.", "Test", 1);
        aEnvelope.setResultSuccess();
        return true;
    }

    @NotNull
    public IApplicationDescription getDescription() {
        return mDesc;
    }

    @NotNull
    public UUID getInstanceId() {
        return this.mContext.getInstanceId();
    }

    public void notifyStopped() {
    }

    public void pause() {
    }

    public boolean requestStop() {
        return true;
    }

    public void resume() {
    }

    public void start(@NotNull IApplicationContext aContext) throws CException {
        this.mContext = aContext;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.mContext.getNamespace().getTargetRegistry().registerTarget((ITarget)this);
    }

    public void stop() {
        this.mContext.getNamespace().getTargetRegistry().deregisterTarget(this.getAddress().getTID());
    }

    static {
        mDesc.setName("TestApp");
        mDesc.setShortDescription("Test Application");
        mDesc.setLongDescription("A simple Test Application.");
        mDesc.setIconPath(null);
    }
}

