/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.util;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.packets.IPacketMessage;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilAes {
    private static final ILogger LOG_AES = CLoggerFactory.getLogger((String)"network.aes");
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilAes.class);

    private CUtilAes() {
    }

    public static byte @Nullable [] pack(byte @NotNull [] aBytes, @NotNull SecretKey aKey, @NotNull IPacketMessage aPacket) {
        try {
            LOG_AES.trace("AES Encrypt: key = {}", new Object[]{aKey.hashCode()});
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, aKey);
            return cipher.doFinal(aBytes);
        }
        catch (Throwable e) {
            LOG_AES.error(e, "Error on encrypting. {} -> {}", new Object[]{aPacket.getSource(), aPacket.getDestination()});
            LOG.error(e, "Error on encrypting.");
            return null;
        }
    }

    public static byte @NotNull [] unpack(byte @NotNull [] aBytes, @NotNull SecretKey aKey, @NotNull IPacketMessage aPacket) throws CException {
        try {
            LOG_AES.trace("AES Decrypt: key = {}", new Object[]{aKey.hashCode()});
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aKey);
            return cipher.doFinal(aBytes);
        }
        catch (Exception e) {
            LOG_AES.error((Throwable)e, "Error decrypting AES message -> Request node record again. {} -> {}", new Object[]{aPacket.getSource(), aPacket.getDestination()});
            LOG.error((Throwable)e, "Error decrypting AES message -> Request node record again.");
            throw new CException(26).append((Object)e);
        }
    }
}

