/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.nodechooserdlg;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.network.nodechooserdlg.CSignalsNodeChooserDialog;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.signal.properties.IPropertySignal;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.signal.properties.IPropertySignalListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class CDialog
extends JDialog
implements ActionListener,
IPropertySignalListener {
    private static final long serialVersionUID = -4558769080439881371L;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 200;
    private static final int LIST_BOX_INSET = 8;
    private static final String CMD_OKAY = "Okay";
    private static final String CMD_CANCEL = "Cancel";
    private static final Border BORDER1 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
    private static final int GAP1 = 5;
    private final IPropertySignalDispatcher mSignalDispatcher;
    private final CTargetAddress mOwner;
    private JList<CNodeInfo> mListBox;

    CDialog(Collection<CNodeInfo> aNodes, Dialog aParentWindow, String aTitle, boolean aModal, IPropertySignalDispatcher aSignalDispatcher, CTargetAddress aOwner) {
        super(aParentWindow, aTitle, aModal);
        this.mOwner = aOwner;
        this.mSignalDispatcher = aSignalDispatcher;
        this.init(aNodes);
    }

    CDialog(Collection<CNodeInfo> aNodes, Frame aParentWindow, String aTitle, boolean aModal, IPropertySignalDispatcher aSignalDispatcher, CTargetAddress aOwner) {
        super(aParentWindow, aTitle, aModal);
        this.mOwner = aOwner;
        this.mSignalDispatcher = aSignalDispatcher;
        this.init(aNodes);
    }

    CDialog(Collection<CNodeInfo> aNodes, Window aParentWindow, String aTitle, boolean aModal, IPropertySignalDispatcher aSignalDispatcher, CTargetAddress aOwner) {
        super(aParentWindow, aTitle, aModal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.mOwner = aOwner;
        this.mSignalDispatcher = aSignalDispatcher;
        this.init(aNodes);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        switch (aEvent.getActionCommand()) {
            case "Okay": {
                CNodeInfo value = this.mListBox.getSelectedValue();
                if (value == null) break;
                IPropertySignal signal = this.mSignalDispatcher.createSignal(CSignalsNodeChooserDialog.SIGNAL_NODE_CHOOSED);
                signal.set("NODE_ID", (Object)value.getNodeAddress());
                signal.set("OWNER", (Object)this.mOwner);
                this.mSignalDispatcher.signal(signal);
                this.dispose();
                break;
            }
            case "Cancel": {
                IPropertySignal signal = this.mSignalDispatcher.createSignal(CSignalsNodeChooserDialog.SIGNAL_CANCELLED);
                signal.set("OWNER", (Object)this.mOwner);
                this.mSignalDispatcher.signal(signal);
                this.dispose();
                break;
            }
        }
    }

    public void incomingSignal(IPropertySignal aSignal) {
        CTargetAddress owner;
        UUID id = aSignal.getSignalID();
        if (CSignalsNodeChooserDialog.SIGNAL_CANCEL.equals(id) && this.mOwner.equals((Object)(owner = aSignal.getTargetAddress("OWNER", null)))) {
            IPropertySignal signal = this.mSignalDispatcher.createSignal(CSignalsNodeChooserDialog.SIGNAL_CANCELLED);
            signal.set("OWNER", (Object)this.mOwner);
            this.mSignalDispatcher.signal(signal);
            this.dispose();
        }
    }

    private void init(Collection<CNodeInfo> aNodeRecords) {
        CNodeInfo[] connections = new CNodeInfo[aNodeRecords.size()];
        CNodeInfo[] connections1 = aNodeRecords.toArray(connections);
        Arrays.sort(connections1, (o1, o2) -> {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        });
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.setBackground(Color.RED);
        p1.setBorder(BORDER1);
        this.mListBox = new JList<CNodeInfo>(connections1);
        this.mListBox.setBorder(BORDER1);
        CNodeInfo conn = connections1[0];
        this.mListBox.setSelectedValue(conn, true);
        p1.add(this.mListBox, "Center");
        this.add(p1);
        JPanel p2 = new JPanel();
        p2.setBackground(Color.RED);
        p2.setBorder(BORDER1);
        p2.setLayout(new BoxLayout(p2, 0));
        p2.add(Box.createHorizontalGlue());
        JButton ok = new JButton(CMD_OKAY);
        ok.setActionCommand(CMD_OKAY);
        ok.addActionListener(this);
        p2.add(ok);
        p2.add(Box.createHorizontalStrut(5));
        JButton cancel = new JButton(CMD_CANCEL);
        cancel.setActionCommand(CMD_CANCEL);
        cancel.addActionListener(this);
        p2.add(cancel);
        this.add((Component)p2, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

