/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.link.collector.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordLinkCollectorSyncLinks
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"3f0a95f5-d412-4a1e-88d1-2c9760dc9133");
    public static final String NAME = "LinkCollectorSyncLinks";
    public static final String DESCRIPTION = "Tell all direct links of a single node for synchronization";
    public static final String SLOT_COSTS = "2";
    public static final String SLOT_REMOTE_NODES = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static int[] getCosts(@NotNull CRecord aRecord, int[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COSTS);
        if (slot == null) {
            return aDefault;
        }
        return (int[])slot.getValue();
    }

    public static CNodeAddress[] getRemoteNodes(@NotNull CRecord aRecord, CNodeAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_NODES);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress[])slot.getValue();
    }

    public static void setCosts(@NotNull CRecord aRecord, int[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_COSTS, slot);
    }

    public static void setRemoteNodes(@NotNull CRecord aRecord, CNodeAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_NODES, slot);
    }
}

