/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.impl.software.updater.local.CSerialJobMachine;
import de.sillysky.nyssr.kernel.configuration.ESystemExit;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueEntry;
import org.jetbrains.annotations.NotNull;

class CJobReboot
implements ISerialJobQueueEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJobReboot.class);
    private final CSerialJobMachine mParent;

    CJobReboot(@NotNull CSerialJobMachine aParent) {
        this.mParent = aParent;
    }

    @NotNull
    public String getId() {
        return "reboot";
    }

    public void stop() {
    }

    public void start() {
        boolean hasRight = this.mParent.checkRight("NY_Shutdown");
        if (!hasRight) {
            LOG.error("Insufficient rights to perform reboot");
            this.mParent.jobFinished(this);
            return;
        }
        boolean libUpdated = this.mParent.isLibUpdated();
        boolean pluginsUpdated = this.mParent.isPluginsUpdated();
        if (libUpdated) {
            if (pluginsUpdated) {
                System.exit(ESystemExit.REBOOT_AND_UPDATE_LIB_AND_PLUGINS.getValue());
            } else {
                System.exit(ESystemExit.REBOOT_AND_UPDATE_LIB.getValue());
            }
        } else if (pluginsUpdated) {
            System.exit(ESystemExit.REBOOT_AND_UPDATE_PLUGINS.getValue());
        } else {
            System.exit(ESystemExit.REBOOT.getValue());
        }
    }
}

