/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.socket;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.web.socket.CWebSocketConnection;
import de.sillysky.nyssr.impl.web.socket.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.target.ITarget;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CWebSocketServer
extends WebSocketServer {
    private final Map<WebSocket, CWebSocketConnection> mConnectionMap = new HashMap<WebSocket, CWebSocketConnection>();
    private final ILogger LOG = CLoggerFactory.getLogger(CWebSocketServer.class);
    private final ITarget mTarget;
    private final IDependencies mDependencies;

    CWebSocketServer(@NotNull ITarget aTarget, @NotNull IDependencies aDependencies, int aPort) {
        super(new InetSocketAddress(aPort));
        this.mTarget = aTarget;
        this.mDependencies = aDependencies;
    }

    @Override
    public void onOpen(@NotNull WebSocket aSocket, @NotNull ClientHandshake aHandshake) {
        try {
            CWebSocketConnection conn = new CWebSocketConnection(this.mDependencies, aSocket, aHandshake);
            this.mTarget.getTargetRegistry().registerTarget((ITarget)conn);
            this.mConnectionMap.put(aSocket, conn);
        }
        catch (CException aE) {
            this.LOG.error((Throwable)aE, "Couldn't start WebSocketConnectionTarget.");
        }
    }

    @Override
    public void onClose(@NotNull WebSocket aSocket, int aCode, String aReason, boolean aRemote) {
        CWebSocketConnection conn = this.mConnectionMap.remove(aSocket);
        if (conn != null) {
            conn.deactivate();
        }
    }

    @Override
    public void onMessage(@NotNull WebSocket aSocket, @NotNull String aMessage) {
        CWebSocketConnection connection = this.mConnectionMap.get(aSocket);
        if (connection != null) {
            connection.onMessage(aMessage);
        }
    }

    @Override
    public void onMessage(@NotNull WebSocket aSocket, @NotNull ByteBuffer aMessage) {
    }

    @Override
    public void onError(@Nullable WebSocket conn, @NotNull Exception ex) {
        ex.printStackTrace();
        if (conn != null) {
            this.LOG.error((Throwable)ex, ex.getMessage());
        }
    }

    @Override
    public void onStart() {
        this.setConnectionLostTimeout(0);
        this.setConnectionLostTimeout(100);
    }
}

