/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.link.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CSegmentRoutingHint {
    private final CSegmentId mSegment;
    private final CNodeId mLocalNode;

    public CSegmentRoutingHint(@NotNull CSegmentId aSegment, @NotNull CNodeId aLocalNode) {
        this.mSegment = aSegment;
        this.mLocalNode = aLocalNode;
    }

    @NotNull
    public CSegmentId getSegment() {
        return this.mSegment;
    }

    @NotNull
    public CNodeId getLocalNode() {
        return this.mLocalNode;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSegmentRoutingHint that = (CSegmentRoutingHint)aO;
        return this.mSegment.equals((Object)that.mSegment) && this.mLocalNode.equals((Object)that.mLocalNode);
    }

    public int hashCode() {
        return Objects.hash(this.mSegment, this.mLocalNode);
    }

    public String toString() {
        return "{" + this.mLocalNode + " --> " + this.mSegment + "}";
    }

    public boolean hasNode(CNodeAddress aNode) {
        return this.mLocalNode.equals((Object)aNode.getNodeId()) || this.mSegment.equals((Object)aNode.getSegmentId());
    }
}

