/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.choosenode;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.web.dialog.choosenode.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.link.CLinkDto;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetLinks;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetListOfReachableNodes;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class C00401ChooseNode
extends CTarget {
    private final String mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mParentWidgetId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_00401_DIALOG = "id_00401_dialog";
    private static final String ID_00401_CANCEL = "id_00401_cancel";
    private static final String ID_00401_SAVE = "id_00401_save";
    private static final String ID_00401_DETAILS = "id_00401_details";
    private static final String ID_00401_FILTER = "id_00401_filter";
    private static final String ID_00401_NODES = "id_00401_nodes";
    private static final String ID_SCRIPT1 = "id_00401_graph";
    private static final String ID_SCRIPT2 = "id_00401_d3js";
    private static final String ID_CSS = "id_00401_css";
    private static final String[] WIDGETS = new String[]{"id_00401_cancel", "id_00401_save"};
    private TreeSet<CNodeAddress> mNodeAddresses = new TreeSet((aInfo1, aInfo2) -> {
        String info1 = aInfo1.getNodeId().toString();
        String info2 = aInfo2.getNodeId().toString();
        return info1.compareTo(info2);
    });
    private List<CLinkDto> mLinks = new ArrayList<CLinkDto>();

    public C00401ChooseNode(@NotNull String aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mParentWidgetId = aParentWidgetId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordNetworkGetListOfReachableNodes.ID, this::asyncNetworkGetListOfReachableNodes);
        this.addMessageHandler(CRecordNetworkGetLinks.ID, this::asyncNetworkGetLinks);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetNodeData();
        this.mWebApi.registerWidgets(WIDGETS);
        this.mWebApi.removeElement(ID_00401_DIALOG);
        this.mWebApi.removeElement(ID_SCRIPT1);
        this.mWebApi.removeElement(ID_SCRIPT2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String filter = values.get(ID_00401_FILTER, "");
            String string = values.get(ID_00401_NODES, "");
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNetworkGetListOfReachableNodes(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mNodeAddresses.clear();
            CNodeAddress[] addresses = CRecordNetworkGetListOfReachableNodes.getNodes((CRecord)aRecord, null);
            if (addresses != null) {
                this.mNodeAddresses.addAll(Arrays.asList(addresses));
                this.sendGetLinks();
            }
            return true;
        }
        return false;
    }

    private boolean asyncNetworkGetLinks(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord[] records = CRecordNetworkGetLinks.getLinks((CRecord)aRecord, null);
            if (records != null) {
                for (CRecord record : records) {
                    CLinkDto linkDto = CLinkDto.fromRecord((CRecord)record);
                    this.mLinks.add(linkDto);
                }
                this.addCss();
                this.mWebApi.addScript(ID_SCRIPT2, null, "https://d3js.org/d3.v7.min.js");
                this.showDialog();
                this.addJs();
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00401_main.html");
        this.mWebApi.setInnerHtml(this.mParentWidgetId, main);
        this.mWebApi.showModal(ID_00401_DIALOG);
        this.mWebApi.addClickListener1(ID_00401_SAVE, new String[]{ID_00401_FILTER, ID_00401_NODES});
        this.mWebApi.addClickListener2(new String[]{ID_00401_CANCEL});
    }

    private void sendGetNodeData() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkGetListOfReachableNodes.class);
        CRecord record = CRecordNetworkGetListOfReachableNodes.create();
        this.sendRequest(env, record);
    }

    private void sendGetLinks() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkGetLinks.class);
        CRecord record = CRecordNetworkGetLinks.create();
        this.sendRequest(env, record);
    }

    private void addCss() throws CException {
        String css = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00401.css");
        this.mWebApi.addCss(ID_CSS, css);
    }

    private void addJs() throws CException {
        String js = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00401_graph.js");
        StringBuilder sb = new StringBuilder(2000);
        sb.append("var nodes = [\n");
        int size = this.mNodeAddresses.size();
        int i = 1;
        for (CNodeAddress nodeAddress : this.mNodeAddresses) {
            String nodeId = nodeAddress.getNodeId().toString();
            sb.append("{ id: '");
            sb.append(nodeId);
            sb.append("', name: \"");
            sb.append(nodeId);
            sb.append("\" }");
            if (i < size) {
                sb.append(", ");
            }
            sb.append("\n");
            ++i;
        }
        sb.append("];\n");
        sb.append("var links = [\n");
        size = this.mLinks.size();
        i = 1;
        for (CLinkDto link : this.mLinks) {
            String node1 = link.getNode1().getNodeId().toString();
            String node2 = link.getNode2().getNodeId().toString();
            sb.append("{source: '");
            sb.append(node1);
            sb.append("', target: '");
            sb.append(node2);
            sb.append("'}");
            if (i < size) {
                sb.append(", ");
            }
            sb.append("\n");
            ++i;
        }
        sb.append("];\n");
        js = CUtilString.replaceFirstOccurrence((String)js, (String)"[id_00401_nodes]", (String)sb.toString());
        this.mWebApi.addScript(ID_SCRIPT1, js, null);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00401_DIALOG);
        this.mWebApi.removeCss(ID_CSS);
        this.mWebApi.removeScript(ID_SCRIPT1);
        this.mWebApi.removeScript(ID_SCRIPT2);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, new String[]{CConstants.MICRO_SERVICE_ID.valueToString()});
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

