/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.EFontStyle;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventFont
implements IRemoteSkinEvent {
    static final String NAME = "name";
    static final String STYLE = "style";
    static final String SIZE = "size";
    private final String mName;
    private final EFontStyle mStyle;
    private final int mSize;

    public CEventFont(@NotNull Font aFont) {
        this.mName = aFont.getName();
        int s = aFont.getStyle();
        this.mStyle = CEventFont.convertStyleFromSwing(s);
        this.mSize = aFont.getSize();
    }

    public CEventFont(@NotNull String aName, @NotNull EFontStyle aStyle, int aSize) {
        this.mName = aName;
        this.mStyle = aStyle;
        this.mSize = aSize;
    }

    @Nullable
    public static CEventFont create(@Nullable Object aValue) {
        String value;
        String[] split;
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String name = CUtilJsonString.fromJson((CJsonObject)jo, (String)NAME, null);
            if (CUtilString.isValid((String)name)) {
                String s = CUtilJsonString.fromJson((CJsonObject)jo, (String)STYLE, null);
                EFontStyle style = (EFontStyle)((Object)CUtilEnum.fromString(EFontStyle.class, (String)s, (Object)((Object)EFontStyle.plain)));
                int size = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)SIZE, (int)10);
                return new CEventFont(name, style, size);
            }
        } else if (aValue instanceof String && (split = (value = (String)aValue).split(",")).length == 3) {
            EFontStyle fontStyle = (EFontStyle)((Object)CUtilEnum.fromString(EFontStyle.class, (String)split[1], (Object)((Object)EFontStyle.plain)));
            int size = CUtilInteger.fromString((String)split[2], (int)12);
            return new CEventFont(split[0], fontStyle, size);
        }
        return null;
    }

    private static int convertStyleToSwing(@NotNull EFontStyle aStyle) {
        switch (aStyle) {
            case bold: {
                return 1;
            }
            case italic: {
                return 2;
            }
        }
        return 0;
    }

    @NotNull
    private static EFontStyle convertStyleFromSwing(int aStyle) {
        switch (aStyle) {
            case 1: {
                return EFontStyle.bold;
            }
            case 2: {
                return EFontStyle.italic;
            }
        }
        return EFontStyle.plain;
    }

    public Font createFont() {
        return new Font(this.mName, CEventFont.convertStyleToSwing(this.mStyle), this.mSize);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject();
        jo.put(NAME, (Object)this.mName);
        jo.put(STYLE, (Object)this.mStyle.name());
        jo.put(SIZE, (Object)this.mSize);
        return jo;
    }
}

