/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.db;

import de.sillysky.nyssr.impl.record.db.CRecordDatabase;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.record.db.IRecordDatabase;
import de.sillysky.nyssr.record.db.IRecordDatabaseFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.slot.ISlotFactory;
import org.jetbrains.annotations.NotNull;

final class CRecordDatabaseFactory
implements IRecordDatabaseFactory,
IService {
    private ISlotFactory mSlotFactory;
    private INameDb mNameDb;

    CRecordDatabaseFactory() {
    }

    static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(ISlotFactory.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        this.mSlotFactory = (ISlotFactory)aServiceRegistry.getService(ISlotFactory.class);
        aServiceRegistry.registerService(IRecordDatabaseFactory.class, (Object)this);
    }

    @Override
    public IRecordDatabase createRecordDatabase() {
        return new CRecordDatabase(this.mNameDb, this.mSlotFactory);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }
}

