/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSession {
    private final String mSessionToken;
    private final String mUserId;
    private final String[] mRights;

    public CSession(@NotNull String aSessionToken, @NotNull String aUserId, @NotNull String[] aRights) {
        this.mSessionToken = aSessionToken;
        this.mUserId = aUserId;
        this.mRights = aRights;
    }

    @NotNull
    public String getUserId() {
        return this.mUserId;
    }

    @NotNull
    public String[] getRights() {
        return this.mRights;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CSession cSession = (CSession)aOther;
        return this.mUserId.equals(cSession.mUserId);
    }

    public int hashCode() {
        return Objects.hash(this.mUserId);
    }

    @NotNull
    public String getSessionToken() {
        return this.mSessionToken;
    }

    public boolean hasRight(@Nullable String aRight) {
        if (aRight == null) {
            return true;
        }
        String right = aRight.trim().toLowerCase();
        if (right.isEmpty()) {
            return true;
        }
        for (String r : this.mRights) {
            if (!right.equalsIgnoreCase(r)) continue;
            return true;
        }
        return false;
    }
}

