/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.manager;

import de.sillysky.nyssr.app.IApplicationFactoryRegistry;
import de.sillysky.nyssr.app.IApplicationInstanceRegistry;
import de.sillysky.nyssr.impl.app.IApplicationPresetRegistry;
import de.sillysky.nyssr.impl.app.instance.registry.IInternalApplicationInstanceRegistry;
import de.sillysky.nyssr.impl.app.manager.CApplicationManager;
import de.sillysky.nyssr.impl.app.manager.IDependencies;
import de.sillysky.nyssr.impl.shutdown.IShutDownHandler;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplApplicationManager
implements IServiceStarter,
IDependencies {
    private IService mService = null;
    private IApplicationInstanceRegistry mApplicationInstanceRegistry;
    private IInternalApplicationInstanceRegistry mInternalApplicationInstanceRegistry;
    private IRecordHelper mRecordHelper;
    private INamespaceFactory mNamespaceFactory;
    private IApplicationFactoryRegistry mApplicationFactoryRegistry;
    private IApplicationPresetRegistry mApplicationPresetRegistry;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IApplicationInstanceRegistry.class);
        aDependencyList.add(IInternalApplicationInstanceRegistry.class);
        aDependencyList.add(IApplicationPresetRegistry.class);
        aDependencyList.add(IApplicationFactoryRegistry.class);
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(IShutDownHandler.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mApplicationPresetRegistry = (IApplicationPresetRegistry)aServiceRegistry.getServiceOrThrow(IApplicationPresetRegistry.class);
            this.mApplicationFactoryRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getServiceOrThrow(IApplicationFactoryRegistry.class);
            this.mApplicationInstanceRegistry = (IApplicationInstanceRegistry)aServiceRegistry.getServiceOrThrow(IApplicationInstanceRegistry.class);
            this.mInternalApplicationInstanceRegistry = (IInternalApplicationInstanceRegistry)aServiceRegistry.getServiceOrThrow(IInternalApplicationInstanceRegistry.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mRecordHelper = (IRecordHelper)aServiceRegistry.getServiceOrThrow(IRecordHelper.class);
            this.mService = new CApplicationManager(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IApplicationInstanceRegistry getApplicationInstanceRegistry() {
        return this.mApplicationInstanceRegistry;
    }

    @Override
    public IInternalApplicationInstanceRegistry getInternalApplicationInstanceRegistry() {
        return this.mInternalApplicationInstanceRegistry;
    }

    @Override
    public IApplicationPresetRegistry getApplicationPresetRegistry() {
        return this.mApplicationPresetRegistry;
    }

    @Override
    public IApplicationFactoryRegistry getApplicationFactoryRegistry() {
        return this.mApplicationFactoryRegistry;
    }

    @Override
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    public IRecordHelper getRecordHelper() {
        return this.mRecordHelper;
    }
}

