/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.autostart;

import de.sillysky.nyssr.impl.app.IApplicationManager;
import de.sillysky.nyssr.impl.app.IApplicationPresetRegistry;
import de.sillysky.nyssr.impl.app.autostart.CTargetApplicationAutoStart;
import de.sillysky.nyssr.impl.app.autostart.IDependencies;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public class CPackageImplAppAutoStart
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IApplicationPresetRegistry mApplicationPresetRegistry;
    private INameDb mNameDb;
    private ITimerManager mTimerManager;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(ITimerManager.class);
        aDependencyList.add(IApplicationManager.class);
        aDependencyList.add(IApplicationPresetRegistry.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mApplicationPresetRegistry = (IApplicationPresetRegistry)aServiceRegistry.getServiceOrThrow(IApplicationPresetRegistry.class);
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
            this.mService = new CTargetApplicationAutoStart(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IApplicationPresetRegistry getApplicationPresetRegistry() {
        return this.mApplicationPresetRegistry;
    }

    @Override
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    public ITimerManager getTimerManager() {
        return this.mTimerManager;
    }
}

