/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.addroles;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.addroles.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbAddRolesToUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRolesForUser;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Arrays;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class C00302AddRoles
extends CTarget {
    private static final String HTML_00302_MAIN = "/html/00302_main.html";
    private static final String STYLE_SHEET_ID = "id_00302_css";
    private final String mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mUserId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00302_MODAL = "id_00302_modal";
    private static final String ID_00302_CANCEL = "id_00302_cancel";
    private static final String ID_00302_SAVE = "id_00302_save";
    private static final String ID_00302_SELECT = "id_00302_select";
    private static final String[] WIDGETS = new String[]{"id_00302_cancel", "id_00302_save"};
    private CTargetAddress mUserDbAddress;
    private CRole mRole;
    private TreeSet<String> mUserRoles = new TreeSet();
    private TreeSet<String> mAllRoles = new TreeSet();
    private int mGetRoles = 0;

    public C00302AddRoles(@NotNull String aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aUserId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mUserId = aUserId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbGetRolesForUser.ID, this::asyncGetRolesForUser);
        this.addMessageHandler(CRecordUserDbGetRoleList.ID, this::asyncGetRoleList);
        this.addMessageHandler(CRecordUserDbAddRolesToUser.ID, this::asyncUserDbAddRolesToUser);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.mGetRoles = 0;
        this.sendGetRoleList();
        this.sendGetUserRoles(this.mUserId);
        this.mWebApi.registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String arrText = values.get(ID_00302_SELECT, "");
            if (arrText != null && !arrText.isEmpty()) {
                @NotNull String[] arr = CUtilStringArray.fromString((String)arrText);
                this.sendAddRoles(this.mUserId, arr);
            }
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRolesForUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            if (aEnvelope.getResult().isSuccess()) {
                ++this.mGetRoles;
                String[] roles = CRecordUserDbGetRolesForUser.getRoles((CRecord)aRecord, null);
                this.mUserRoles.clear();
                if (roles != null && roles.length > 0) {
                    this.mUserRoles.addAll(Arrays.asList(roles));
                }
                if (this.mGetRoles == 2) {
                    this.showDialog();
                }
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetRoleList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            if (aEnvelope.getResult().isSuccess()) {
                ++this.mGetRoles;
                String[] roles = CRecordUserDbGetRoleList.getRoles((CRecord)aRecord, null);
                this.mAllRoles = new TreeSet<String>(Arrays.asList(roles));
                if (this.mGetRoles == 2) {
                    this.showDialog();
                }
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncUserDbAddRolesToUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mUserDbAddress = aEnvelope.getSender();
                this.finish(0);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        this.mGetRoles = 0;
        this.mWebApi.addCss(STYLE_SHEET_ID, CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00302.css"));
        this.mWebApi.removeElement(ID_00302_MODAL);
        String myMain = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)HTML_00302_MAIN);
        myMain = CUtilString.replaceAllOccurrences((String)myMain, (String)"{user_id}", (String)this.mUserId);
        for (String role : this.mAllRoles) {
            if (this.mUserRoles.contains(role)) continue;
            String sb = "<option value='" + role + "'>" + role + "</option>";
            myMain = CUtilString.insertBeforeFirstOccurrence((String)myMain, (String)"{row}", (String)sb);
        }
        myMain = CUtilString.replaceFirstOccurrence((String)myMain, (String)"{row}", (String)"");
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, myMain);
        this.mWebApi.showModal(ID_00302_MODAL);
        this.mWebApi.addClickListener1(ID_00302_SAVE, new String[]{ID_00302_SELECT});
        this.mWebApi.addClickListener2(new String[]{ID_00302_CANCEL});
    }

    private void sendGetUserRoles(@NotNull String aUserId) throws CException {
        CRecord record = CRecordUserDbGetRolesForUser.create();
        CRecordUserDbGetRolesForUser.setSessionToken((CRecord)record, (String)this.mSessionToken);
        CRecordUserDbGetRolesForUser.setUserId((CRecord)record, (String)aUserId);
        this.sendMessageToSessionManager(record);
    }

    private void sendGetRoleList() throws CException {
        CRecord record = CRecordUserDbGetRoleList.create();
        CRecordUserDbGetRoleList.setSessionToken((CRecord)record, (String)this.mSessionToken);
        this.sendMessageToSessionManager(record);
    }

    private void sendAddRoles(@NotNull String aUserId, @NotNull String[] aRoles) throws CException {
        CRecord record = CRecordUserDbAddRolesToUser.create();
        CRecordUserDbAddRolesToUser.setSessionToken((CRecord)record, (String)this.mSessionToken);
        CRecordUserDbAddRolesToUser.setUserId((CRecord)record, (String)aUserId);
        CRecordUserDbAddRolesToUser.setRoles((CRecord)record, (String[])aRoles);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        this.sendRequest(env, aRecord);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeCss(STYLE_SHEET_ID);
        this.mWebApi.removeElement(ID_00302_MODAL);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, new String[]{CConstants.MICRO_SERVICE_ID.valueToString()});
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

