/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.web.protocol;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CAbstractWebDialog
extends CTarget {
    private final String mSessionToken;
    private final CTargetAddress mRemoteSkinAddress;
    private final CTargetAddress mOwnerAddress;
    private final String mParentWidgetId;
    private final Map<IId, CTargetAddress> mRunningMicroServices = new HashMap<IId, CTargetAddress>(10);
    private final CWebApi mWebApi;
    private final CWebDialogApi mWebDialogApi;
    private final IId mMyMicroServiceId;

    public CAbstractWebDialog(@NotNull String aSessionToken, @NotNull CTargetAddress aRemoteSkinAddress, @NotNull CTargetAddress aOwnerAddress, @NotNull String aParentWidgetId, @NotNull IId mMicroServiceId) {
        this.mSessionToken = aSessionToken;
        this.mRemoteSkinAddress = aRemoteSkinAddress;
        this.mOwnerAddress = aOwnerAddress;
        this.mParentWidgetId = aParentWidgetId;
        this.mMyMicroServiceId = mMicroServiceId;
        this.mWebApi = new CWebApi((ITarget)this, aRemoteSkinAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, aRemoteSkinAddress);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyDialogDismissed.ID, this::asyncWebDialogFinished);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3, null);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDialogFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId microserviceId = CRecordWebNotifyDialogDismissed.getMicroserviceId(aRecord, null);
        if (microserviceId != null) {
            this.mRunningMicroServices.remove(microserviceId);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick2.getId(aRecord, "");
        this.notifyClick2(id);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 5108) {
                this.finish(1, null);
            } else if (resultCode == 0) {
                CTargetAddress address = CRecordShowWebDialog.getDialogTargetAddress(aRecord, null);
                IId microServiceId = aEnvelope.getMicroServiceId();
                if (microServiceId != null) {
                    this.addSubDialog(microServiceId, address);
                }
                this.notifySubDialogShown(microServiceId, address);
            }
            return true;
        }
        return false;
    }

    public void notifySubDialogShown(@Nullable IId aMicroServiceId, @NotNull CTargetAddress aAddress) {
    }

    public void notifyClick2(@NotNull String aWidgetId) throws CException {
    }

    @NotNull
    public CWebApi getWebApi() {
        return this.mWebApi;
    }

    @NotNull
    public CWebDialogApi getWebDialogApi() {
        return this.mWebDialogApi;
    }

    @NotNull
    public String getSessionToken() {
        return this.mSessionToken;
    }

    @NotNull
    public CTargetAddress getRemoteSkinAddress() {
        return this.mRemoteSkinAddress;
    }

    @NotNull
    public CTargetAddress getOwnerAddress() {
        return this.mOwnerAddress;
    }

    @NotNull
    public String getParentWidgetId() {
        return this.mParentWidgetId;
    }

    protected void addSubDialog(@NotNull IId aMicroServiceId, @NotNull CTargetAddress aAddress) {
        this.mRunningMicroServices.put(aMicroServiceId, aAddress);
    }

    protected void finish(int aReason, @Nullable String[] aResults) throws CException {
        for (CTargetAddress address : this.mRunningMicroServices.values()) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord record = CRecordWebDismissDialog.create();
            this.sendNotification(env, record);
        }
        this.getWebDialogApi().notifyDismissed(this.mOwnerAddress, this.mMyMicroServiceId, aReason, aResults);
        this.getWebApi().deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

