/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.monitor;

import de.sillysky.nyssr.app.CApplicationInstance;
import de.sillysky.nyssr.app.network.IAppMonitor;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.index.INetworkIndex;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexAppNotification;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class CTargetAppMonitor
extends CTarget
implements IService,
IAppMonitor {
    private static final String FILTER = "nid=TRANSPORT";
    private final Map<UUID, CApplicationInstance> mAppInstances = new ConcurrentHashMap<UUID, CApplicationInstance>();
    private INetworkIndex mNetworkIndex;

    CTargetAppMonitor() {
    }

    public static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INetworkIndex.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNetworkIndex = (INetworkIndex)aServiceRegistry.getService(INetworkIndex.class);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkIndexAppNotification.ID, this::asyncNetworkIndexAppNotification);
        ITargetRegistry tr = (ITargetRegistry)aServiceRegistry.getServiceOrThrow(ITargetRegistry.class, FILTER);
        tr.registerTarget((ITarget)this);
        aServiceRegistry.registerService(IAppMonitor.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
        this.mNetworkIndex.removeAllListener(this.getAddress());
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mNetworkIndex.addApplicationListener(this.getAddress(), null, null);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNetworkIndexAppNotification(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CRecord record = CRecordNetworkIndexAppNotification.getAppInstance((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)record, (String)"Missing instance", (Object[])new Object[0]);
        CApplicationInstance instance = CApplicationInstance.create((CRecord)record);
        CUtilCheck.checkNotNull((Object)instance, (String)"Invalid Instance Data", (Object[])new Object[0]);
        String type = CRecordNetworkIndexAppNotification.getType((CRecord)aRecord, (String)"");
        if ("ADDED".equals(type)) {
            this.mAppInstances.put(instance.getInstanceId(), instance);
        } else if ("REMOVED".equals(type)) {
            this.mAppInstances.remove(instance.getInstanceId());
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public CApplicationInstance getApplicationById(UUID aAppId) {
        for (CApplicationInstance inst : this.mAppInstances.values()) {
            if (!inst.getApplicationId().equals(aAppId)) continue;
            return inst;
        }
        return null;
    }

    @Override
    public Collection<CApplicationInstance> getApplicationInstances() {
        return new ArrayList<CApplicationInstance>(this.mAppInstances.values());
    }

    @Override
    public Collection<CApplicationInstance> getApplicationsById(UUID aAppId) {
        ArrayList<CApplicationInstance> result = new ArrayList<CApplicationInstance>();
        for (CApplicationInstance inst : this.mAppInstances.values()) {
            if (!inst.getApplicationId().equals(aAppId)) continue;
            result.add(inst);
        }
        return result;
    }
}

