/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.widget.parser.raw;

import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.widget.parser.IWidgetEntry;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CWidgetEntry
implements IWidgetEntry {
    private final String mId;
    private final String mWidgetType;
    private final List<IWidgetEntry> mChildren = new ArrayList<IWidgetEntry>();
    private CJsonObject mAttributes;
    private int mWidgetIndex;
    private IWidgetEntry mParent;
    private CWidgetSetId mPlaceHolderId;
    private final CStringProperties mProperties = new CStringProperties();

    public CWidgetEntry(@NotNull String aId, @NotNull String aWidgetType) {
        this.mId = aId;
        this.mWidgetType = aWidgetType;
    }

    public void setPlaceHolderId(@NotNull String aWidgetSetName, @Nullable String aInstance) {
        this.mPlaceHolderId = CWidgetSetId.create((String)aWidgetSetName, (String)aInstance);
    }

    @Nullable
    public CWidgetSetId getPlaceHolderId() {
        return this.mPlaceHolderId;
    }

    public void addChild(@NotNull IWidgetEntry aEntry) {
        this.mChildren.add(aEntry);
        aEntry.setParent((IWidgetEntry)this);
    }

    public int compareTo(@NotNull IWidgetEntry aOther) {
        return Integer.compare(this.mWidgetIndex, aOther.getWidgetIndex());
    }

    public CJsonObject getAttributes() {
        return this.mAttributes;
    }

    public void setAttributes(@NotNull CJsonObject aAttributes) {
        this.mAttributes = aAttributes;
    }

    @NotNull
    public List<IWidgetEntry> getChildren() {
        return this.mChildren;
    }

    public String getId() {
        return this.mId;
    }

    @Nullable
    public IWidgetEntry getParent() {
        return this.mParent;
    }

    public void setParent(@NotNull IWidgetEntry aParent) {
        this.mParent = aParent;
    }

    public int getWidgetIndex() {
        return this.mWidgetIndex;
    }

    public void setWidgetIndex(int aIndex) {
        this.mWidgetIndex = aIndex;
    }

    public String toString() {
        return "CWidgetEntry{ID='" + this.mId + '\'' + "TYPE='" + this.getWidgetType() + '\'' + '}';
    }

    public String getWidgetType() {
        return this.mWidgetType;
    }

    public CStringProperties getProperties() {
        return this.mProperties;
    }
}

