/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordUserDbGetUserRecord
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"f4459095-3a4a-48e5-8790-9fa3a416b8e4");
    public static final String NAME = "UserDbGetUserRecord";
    public static final String DESCRIPTION = "Get a user for displaying.";
    public static final String SLOT_RIGHTS = "rights";
    public static final String SLOT_ROLES = "roles";
    public static final String SLOT_SESSION_TOKEN = "SessionToken";
    public static final String SLOT_USER = "userRecord";
    public static final String SLOT_USER_ID = "userId";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getRights(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RIGHTS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String[] getRoles(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ROLES);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String getSessionToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CRecord getUser(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_USER);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static String getUserId(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_USER_ID);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setRights(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_RIGHTS, slot);
    }

    public static void setRoles(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_ROLES, slot);
    }

    public static void setSessionToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SESSION_TOKEN, slot);
    }

    public static void setUser(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_USER, slot);
    }

    public static void setUserId(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_USER_ID, slot);
    }
}

