/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordUserDbChangePassword
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"806fcf09-e60c-462f-ba50-3e99c579e74f");
    public static final String NAME = "UserDbChangePassword";
    public static final String DESCRIPTION = "Change a password.";
    public static final String SLOT_CURRENT_PASSWORD = "currPw";
    public static final String SLOT_NEW_PASSWORD = "newPw";
    public static final String SLOT_USER_ID = "user";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getCurrentPassword(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CURRENT_PASSWORD);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getNewPassword(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NEW_PASSWORD);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getUserId(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_USER_ID);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setCurrentPassword(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_CURRENT_PASSWORD, slot);
    }

    public static void setNewPassword(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_NEW_PASSWORD, slot);
    }

    public static void setUserId(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_USER_ID, slot);
    }
}

