/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRoleRecord;
import java.time.LocalDateTime;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CRole {
    private String mId;
    private String mDescription;
    private String mCreatedByUser;
    private final LocalDateTime mTimeCreated;
    private boolean mProtected;

    public CRole(@NotNull String aId, @NotNull String aDescription, boolean aProtected, @NotNull String aCreatedByUser, @NotNull LocalDateTime aTimeCreated) {
        this.mId = aId;
        this.mDescription = aDescription;
        this.mProtected = aProtected;
        this.mCreatedByUser = aCreatedByUser;
        this.mTimeCreated = aTimeCreated;
    }

    public CRole(@NotNull CRole aRole) {
        this.mId = aRole.mId;
        this.mDescription = aRole.mDescription;
        this.mProtected = aRole.mProtected;
        this.mCreatedByUser = aRole.mCreatedByUser;
        this.mTimeCreated = aRole.mTimeCreated;
    }

    public CRole(@NotNull CRecord aRecord) {
        this.mId = CRecordUserDbRoleRecord.getRoleId(aRecord, "");
        this.mDescription = CRecordUserDbRoleRecord.getDescription(aRecord, "");
        this.mProtected = CRecordUserDbRoleRecord.getIsProtected(aRecord, false);
        this.mCreatedByUser = CRecordUserDbRoleRecord.getCreatedBy(aRecord, "");
        this.mTimeCreated = CRecordUserDbRoleRecord.getTimeCreated(aRecord, LocalDateTime.now());
    }

    public CRole() {
        this.mId = "";
        this.mDescription = "";
        this.mProtected = false;
        this.mCreatedByUser = "";
        this.mTimeCreated = LocalDateTime.now();
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    public void setId(@NotNull String aId) {
        this.mId = aId;
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(@NotNull String aDescription) {
        this.mDescription = aDescription;
    }

    public boolean isProtected() {
        return this.mProtected;
    }

    public void setProtected(boolean aIsProtected) {
        this.mProtected = aIsProtected;
    }

    @NotNull
    public String getCreatedByUser() {
        return this.mCreatedByUser;
    }

    public void setCreatedByUser(@NotNull String aCreatedByUser) {
        this.mCreatedByUser = aCreatedByUser;
    }

    @NotNull
    public LocalDateTime getTimeCreated() {
        return this.mTimeCreated;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CRole group = (CRole)aO;
        return this.mId.equals(group.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public CRecord toRecord() throws CException {
        CRecord record = CRecordUserDbRoleRecord.create();
        if (!this.mId.isEmpty()) {
            CRecordUserDbRoleRecord.setRoleId(record, this.mId);
        }
        if (!this.mDescription.isEmpty()) {
            CRecordUserDbRoleRecord.setDescription(record, this.mDescription);
        }
        if (this.mProtected) {
            CRecordUserDbRoleRecord.setIsProtected(record, true);
        }
        if (!this.mCreatedByUser.isEmpty()) {
            CRecordUserDbRoleRecord.setCreatedBy(record, this.mCreatedByUser);
        }
        CRecordUserDbRoleRecord.setTimeCreated(record, this.mTimeCreated);
        return record;
    }
}

