/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.userlist;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.userlist.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyTableRowClicked;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class C00310UserList
extends CTarget {
    private static final IId MICRO_SERVICE_EDIT_USER = CIdFactory.fromObject((Object)"NY_WebDialogEditUser_00301");
    private static final IId MICRO_SERVICE_ADD_USER = CIdFactory.fromObject((Object)"NY_WebDialogAddUser_00303");
    private static final IId MICRO_SERVICE_CHANGE_PASSWORD = CIdFactory.fromObject((Object)"NY_WebDialogChangePassword_00309");
    private static final IId MICRO_SERVICE_YES_NO = CIdFactory.fromObject((Object)"NY_WebDialogYesNo_00001");
    private static final IId MICRO_SERVICE_ADD_ROLES = CIdFactory.fromObject((Object)"NY_WebDialogAddRoles_00302");
    private static final IId MICRO_SERVICE_REMOVE_ROLES = CIdFactory.fromObject((Object)"NY_WebDialogRemoveRoles_00313");
    private static final String ID_EDIT_USER = "id_00310_edit_user";
    private static final String ID_DELETE_USER = "id_00310_delete_user";
    private static final String ID_ADD_USER = "id_00310_add_user";
    private static final String ID_CHANGE_PW = "id_00310_change_pw";
    private static final String ID_ADD_ROLES = "id_00310_add_roles";
    private static final String ID_REMOVE_ROLES = "id_00310_remove_roles";
    private static final String ID_TABLE_USER = "id_00310_table_user";
    private static final String ID_CHANGE_PW_ENTRY = "id_00310_change_password_entry";
    private static final String ID_USER_ID = "id_00310_userid";
    private static final String ID_REAL_NAME = "id_00310_real_name";
    private static final String ID_EMAIL = "id_00310_email";
    private static final String ID_PICTURE = "id_00310_picture";
    private static final String ID_CREATED_BY = "id_00310_created_by";
    private static final String ID_ROLES = "id_00310_roles";
    private static final String ID_RIGHTS = "id_00310_rights";
    private static final String[] WIDGET_IDS = new String[]{"id_00310_edit_user", "id_00310_delete_user", "id_00310_add_user", "id_00310_change_pw", "id_00310_add_roles", "id_00310_remove_roles"};
    private final String mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mParentWidgetId;
    private final Map<IId, CTargetAddress> mRunningMicroServices = new HashMap<IId, CTargetAddress>(10);
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private CTargetAddress mUserDbAddress;
    private String mSessionUserId;
    private String[] mSessionRights;
    private String mNextUser;
    private CUser mUser;
    private String[] mRolesOfUser;
    private String[] mRights;
    private List<String> mSortedUserList;

    public C00310UserList(@NotNull String aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mParentWidgetId = aParentWidgetId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
        this.addMessageHandler(CRecordUserDbGetUserList.ID, this::asyncGetUserList);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebOnClick2);
        this.addMessageHandler(CRecordWebNotifyTableRowClicked.ID, this::asyncWebNotifyTableRowClicked);
        this.addMessageHandler(CRecordUserDbGetUserRecord.ID, this::asyncGetUserRecord);
        this.addMessageHandler(CRecordUserDbDeleteUser.ID, this::asyncDeleteUser);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
        this.addMessageHandler(CRecordWebNotifyDialogDismissed.ID, this::asyncWebDialogFinished);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetSessionData();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResultCode() == 0) {
                this.mSessionUserId = CRecordSessionValidate.getUserId((CRecord)aRecord, null);
                this.mSessionRights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
                this.mWebApi.registerWidgets(WIDGET_IDS);
                String html = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00310_main.html");
                this.mWebApi.setInnerHtml(this.mParentWidgetId, html);
                this.sendGetUserList();
            } else {
                this.sendFinished();
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetUserList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mUserDbAddress = aEnvelope.getSender();
                String[] userIds = CRecordUserDbGetUserList.getUserIds((CRecord)aRecord, null);
                ArrayList<String> userList = new ArrayList<String>(Arrays.asList(userIds));
                this.mSortedUserList = userList.stream().sorted(String::compareTo).collect(Collectors.toList());
                this.createUserTable();
                if (CUtilString.isValid((String)this.mNextUser)) {
                    this.sendGetUserData(this.mNextUser);
                    this.mNextUser = null;
                }
            } else if (resultCode == 5108) {
                this.sendFinished();
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetUserRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                CRecord userRecord = CRecordUserDbGetUserRecord.getUser((CRecord)aRecord, null);
                this.mUser = CUser.fromRecord((CRecord)userRecord);
                this.mRolesOfUser = CRecordUserDbGetUserRecord.getRoles((CRecord)aRecord, (String[])new String[0]);
                this.mRights = CRecordUserDbGetUserRecord.getRights((CRecord)aRecord, (String[])new String[0]);
                this.updateUser(this.mUser, this.mRolesOfUser, this.mRights);
            } else if (resultCode == 5108) {
                this.sendFinished();
            }
            return true;
        }
        return false;
    }

    private boolean asyncDeleteUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.sendGetUserList();
            } else if (resultCode == 5108) {
                this.sendFinished();
            }
            return true;
        }
        return false;
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 5108) {
                this.sendFinished();
            } else if (resultCode == 0) {
                CTargetAddress address = CRecordShowWebDialog.getDialogTargetAddress((CRecord)aRecord, null);
                IId microServiceId = aEnvelope.getMicroServiceId();
                this.mRunningMicroServices.put(microServiceId, address);
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebDialogFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mNextUser = null;
        int reason = CRecordWebNotifyDialogDismissed.getReason((CRecord)aRecord, (int)-1);
        IId microserviceId = CRecordWebNotifyDialogDismissed.getMicroserviceId((CRecord)aRecord, null);
        this.mRunningMicroServices.remove(microserviceId);
        if (reason == 0) {
            String[] results = CRecordWebNotifyDialogDismissed.getResults((CRecord)aRecord, null);
            if (MICRO_SERVICE_EDIT_USER.equals((Object)microserviceId) || MICRO_SERVICE_ADD_ROLES.equals((Object)microserviceId) || MICRO_SERVICE_REMOVE_ROLES.equals((Object)microserviceId)) {
                this.sendGetUserData(this.mUser.getId());
            } else if (MICRO_SERVICE_ADD_USER.equals((Object)microserviceId)) {
                this.sendGetUserList();
                this.mNextUser = results[0];
            } else if (MICRO_SERVICE_YES_NO.equals((Object)microserviceId) && "yes".equals(results[0])) {
                this.sendDeleteUser();
                this.mNextUser = "admin";
            }
        } else if (reason == 1) {
            this.sendFinished();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebOnClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick2.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing id on onClick", (Object[])new Object[0]);
        switch (id) {
            case "id_00310_edit_user": {
                this.openDialogEditUser();
                break;
            }
            case "id_00310_add_user": {
                this.openDialogAddUser();
                break;
            }
            case "id_00310_delete_user": {
                this.openDialogYesNo("Would you like to delete user " + this.mUser.getId() + "?");
                break;
            }
            case "id_00310_change_pw": {
                this.openDialogChangePassword();
                break;
            }
            case "id_00310_add_roles": {
                this.openDialogAddRoles(this.mUser.getId());
                break;
            }
            case "id_00310_remove_roles": {
                this.openDialogRemoveRoles(this.mUser.getId());
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyTableRowClicked(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyTableRowClicked.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing id on NotifyTableRowClicked", (Object[])new Object[0]);
        String[] data = CRecordWebNotifyTableRowClicked.getData((CRecord)aRecord, null);
        if (data != null && data.length > 0) {
            String userId = data[0];
            if (this.mUser != null && !this.mUser.getId().equals(userId)) {
                this.markCurrentUserInactive();
            }
            this.markUserActive(userId);
            this.sendGetUserData(userId);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void markCurrentUserInactive() throws CException {
        this.mWebApi.removeClassFromElement("#row_" + this.mUser.getId(), "uk-active");
    }

    private void markUserActive(@NotNull String aUserId) throws CException {
        this.mWebApi.addClassToElement("#row_" + aUserId, "uk-active");
    }

    private void createUserTable() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00310_main.html");
        String table = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00310_table.html");
        String row = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00310_row.html");
        String currentTable = table;
        for (String userId : this.mSortedUserList) {
            String currentRow = row;
            currentRow = CUtilString.replaceAllOccurrences((String)currentRow, (String)"{userid}", (String)userId);
            currentTable = CUtilString.insertBeforeFirstOccurrence((String)currentTable, (String)"{row}", (String)currentRow);
        }
        currentTable = CUtilString.replaceFirstOccurrence((String)currentTable, (String)"{row}", (String)"");
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{table_users}", (String)currentTable);
        this.mWebApi.setInnerHtml(this.mParentWidgetId, main);
        this.mWebApi.addTableRowListener(ID_TABLE_USER);
        if (this.mNextUser == null) {
            this.mNextUser = this.mSortedUserList.get(0);
        }
        if (CUtilString.isValid((String)this.mNextUser)) {
            this.sendGetUserData(this.mNextUser);
            this.markUserActive(this.mNextUser);
        }
    }

    private void updateUser(@NotNull CUser aUser, String @NotNull [] aRolesOfUser, String[] aRights) throws CException {
        this.mWebApi.setInnerHtml(ID_USER_ID, aUser.getId());
        this.mWebApi.setInnerHtml(ID_REAL_NAME, aUser.getRealName());
        this.mWebApi.setInnerHtml(ID_EMAIL, aUser.getEmail());
        this.mWebApi.setInnerHtml(ID_PICTURE, aUser.getPicture());
        this.mWebApi.setInnerHtml(ID_CREATED_BY, aUser.getTimeCreated() + " by " + aUser.getCreatedByUser());
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<ul class=\"uk-list uk-list-circle\">");
        for (String role : aRolesOfUser) {
            sb.append("<li>").append(role).append("</li>");
        }
        sb.append("</ul>");
        this.mWebApi.setInnerHtml(ID_ROLES, sb.toString());
        sb.append("<ul class=\"uk-list uk-list-circle\">");
        for (String right : aRights) {
            sb.append("<li>").append(right).append("</li>");
        }
        sb.append("</ul>");
        this.mWebApi.setInnerHtml(ID_RIGHTS, sb.toString());
        this.enableChangePasswordMenuItem();
    }

    private void enableChangePasswordMenuItem() throws CException {
        CStringProperties sp = new CStringProperties();
        if (this.mSessionUserId.equals(this.mUser.getId()) || CUtilStringArray.contains((String[])this.mSessionRights, (String)"NY_ChangePassword")) {
            sp.put("display", "list_item");
        } else {
            sp.put("display", "none");
        }
        this.mWebApi.setStylesForElements("#id_00310_change_password_entry", sp);
    }

    private void sendGetUserList() throws CException {
        CRecord record = CRecordUserDbGetUserList.create();
        CRecordUserDbGetUserList.setSessionToken((CRecord)record, (String)this.mSessionToken);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        this.sendRequest(env, aRecord);
    }

    private void sendGetUserData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetUserRecord.create();
        CRecordUserDbGetUserRecord.setSessionToken((CRecord)record, (String)this.mSessionToken);
        CRecordUserDbGetUserRecord.setUserId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    private void sendGetSessionData() throws CException {
        CRecord record = CRecordSessionValidate.create();
        CRecordSessionValidate.setToken((CRecord)record, (String)this.mSessionToken);
        this.sendMessageToSessionManager(record);
    }

    private void sendDeleteUser() throws CException {
        String id = this.mUser.getId();
        CRecord record = CRecordUserDbDeleteUser.create();
        CRecordUserDbDeleteUser.setSessionToken((CRecord)record, (String)this.mSessionToken);
        CRecordUserDbDeleteUser.setUserId((CRecord)record, (String)id);
        this.sendMessageToSessionManager(record);
    }

    private void openDialogEditUser() throws CException {
        String[] params = new String[]{this.mUser.getId()};
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_EDIT_USER, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogAddUser() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_ADD_USER, this.mSessionToken, "id_00300_modal", null);
    }

    private void openDialogChangePassword() throws CException {
        String[] params = new String[]{this.mUser.getId()};
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_CHANGE_PASSWORD, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogYesNo(@NotNull String aMessage) throws CException {
        String[] params = new String[]{aMessage};
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_YES_NO, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogAddRoles(@NotNull String aUserId) throws CException {
        String[] params = new String[]{aUserId};
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_ADD_ROLES, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogRemoveRoles(@NotNull String aUserId) throws CException {
        String[] params = new String[]{aUserId};
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_REMOVE_ROLES, this.mSessionToken, "id_00300_modal", params);
    }

    private void sendFinished() throws CException {
        for (CTargetAddress address : this.mRunningMicroServices.values()) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord record = CRecordWebDismissDialog.create();
            this.sendNotification(env, record);
        }
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, 1, null);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

