/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelAttributes;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTreeNode
implements IRemoteSkinEvent {
    static final String ID = "id";
    static final String CHILDREN = "children";
    private final String mId;
    private final LinkedList<CEventTreeNode> mChildren = new LinkedList();
    private final CEventLabelAttributes mLabelAttributes;
    private CEventTreeNode mParent;

    private CEventTreeNode(@NotNull String aId, @NotNull String aDisplayedText, @Nullable CEventIcon aIcon, @Nullable List<CEventTreeNode> aChildren) {
        this(aId, aDisplayedText, aIcon);
        if (aChildren != null) {
            for (CEventTreeNode child : aChildren) {
                this.addChild(child);
            }
        }
    }

    public CEventTreeNode(@NotNull String aId, @NotNull String aDisplayedText, @Nullable CEventIcon aIcon) {
        this.mId = aId;
        this.mLabelAttributes = new CEventLabelAttributes();
        this.mLabelAttributes.setValue(aDisplayedText);
        this.mLabelAttributes.setIcon(aIcon);
    }

    private CEventTreeNode(@NotNull String aId, @NotNull CEventLabelAttributes aLabelAttributes) {
        this.mId = aId;
        this.mLabelAttributes = aLabelAttributes;
    }

    @Nullable
    public static CEventTreeNode create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            return CEventTreeNode.readNode(jo);
        }
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            for (Object child : arr.getChildren()) {
                CEventTreeNode node;
                if (!(child instanceof CJsonObject) || (node = CEventTreeNode.readNode((CJsonObject)child)) == null) continue;
                return node;
            }
        }
        return null;
    }

    @Nullable
    private static CEventTreeNode readNode(@NotNull CJsonObject aJsonObject) {
        CEventLabelAttributes labelAttributes;
        String id = CUtilJsonString.fromJson((CJsonObject)aJsonObject, (String)ID, null);
        if (CUtilString.isValid((String)id) && (labelAttributes = CEventLabelAttributes.create(aJsonObject)) != null) {
            CEventTreeNode node = new CEventTreeNode(id, labelAttributes);
            ArrayList children = new ArrayList();
            Object o = aJsonObject.getValue(CHILDREN);
            if (o instanceof CJsonArray) {
                CJsonArray arr = (CJsonArray)o;
                for (Object c : arr.getChildren()) {
                    CEventTreeNode child;
                    if (!(c instanceof CJsonObject) || (child = CEventTreeNode.readNode((CJsonObject)c)) == null) continue;
                    node.addChild(child);
                }
            }
            return node;
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonArray arr = new CJsonArray();
        for (CEventTreeNode node : this.mChildren) {
            this.writeNode(arr, node);
        }
        return arr;
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public String getDisplayedText() {
        return this.mLabelAttributes.getDisplayedText();
    }

    @Nullable
    public CEventIcon getIcon() {
        return this.mLabelAttributes.getIcon();
    }

    @Nullable
    public CEventColor getBackground() {
        return this.mLabelAttributes.getBackground();
    }

    public void setBackground(CEventColor aBackground) {
        this.mLabelAttributes.setBackground(aBackground);
    }

    @Nullable
    public CEventColor getForeground() {
        return this.mLabelAttributes.getForeground();
    }

    public void setForeground(CEventColor aForeground) {
        this.mLabelAttributes.setForeground(aForeground);
    }

    @Nullable
    public IBorder getBorder() {
        return this.mLabelAttributes.getBorder();
    }

    public void setBorder(IBorder aBorder) {
        this.mLabelAttributes.setBorder(aBorder);
    }

    @Nullable
    public CEventFont getFont() {
        return this.mLabelAttributes.getFont();
    }

    public void setFont(CEventFont aFont) {
        this.mLabelAttributes.setFont(aFont);
    }

    @Nullable
    public CEventTreeNode getParent() {
        return this.mParent;
    }

    public void setParent(@Nullable CEventTreeNode aParent) {
        this.mParent = aParent;
    }

    public String getTooltip() {
        return this.mLabelAttributes.getTooltip();
    }

    public void setTooltip(String aText) {
        this.mLabelAttributes.setTooltip(aText);
    }

    public void addChild(@NotNull CEventTreeNode aNode) {
        this.mChildren.add(aNode);
    }

    public void removeChild(@NotNull CEventTreeNode aNode) {
        this.mChildren.remove(aNode);
    }

    @NotNull
    public LinkedList<CEventTreeNode> children() {
        return this.mChildren;
    }

    private void writeNode(@NotNull CJsonArray aJsonArray, @NotNull CEventTreeNode aNode) {
        CJsonObject jo = (CJsonObject)this.mLabelAttributes.toJson();
        jo.put(ID, (Object)this.mId);
        if (!this.mChildren.isEmpty()) {
            CJsonArray arr = new CJsonArray();
            for (CEventTreeNode node : this.mChildren) {
                this.writeNode(arr, node);
            }
            jo.put(CHILDREN, (Object)arr);
        }
        aJsonArray.add((Object)jo);
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CEventTreeNode node = (CEventTreeNode)aO;
        return this.mId.equals(node.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public String toString() {
        return this.mLabelAttributes.getDisplayedText();
    }
}

