/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.hash.CUtilPassword;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventPasswordNotification
implements IRemoteSkinEvent {
    private static final String KEY_PASSWORD = "pw";
    private static final String KEY_HAS_CAPITAL = "hasCapitalAndSmall";
    private static final String KEY_HAS_SPECIAL = "hasSpecial";
    private static final String KEY_HAS_DIGITS = "hasDigits";
    private static final String KEY_LENGTH = "length";
    private static final String KEY_ENCODING = "encoding";
    private final String mEncodedPasswordBase64;
    private final String mEncoding;
    private boolean mHasCapitalAndSmallLetters;
    private boolean mHasSpecialCharacters;
    private boolean mHasDigits;
    private int mLength;

    public CEventPasswordNotification(char[] aPassword) {
        this.mEncodedPasswordBase64 = this.encode(aPassword);
        this.mEncoding = aPassword.length == 0 ? "" : "SHA384";
        Arrays.fill(aPassword, '\u0000');
    }

    public CEventPasswordNotification(String aPassword, String aEncoding) {
        this.mEncodedPasswordBase64 = aPassword;
        this.mEncoding = aEncoding;
    }

    public static CEventPasswordNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String pw = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_PASSWORD, (String)"");
            String encoding = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_ENCODING, (String)"");
            CEventPasswordNotification event = new CEventPasswordNotification(pw, encoding);
            event.setHasCapitalAndSmallLetters(CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_HAS_CAPITAL, (boolean)false));
            event.setHasSpecialCharacters(CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_HAS_SPECIAL, (boolean)false));
            event.setHasDigits(CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_HAS_DIGITS, (boolean)false));
            event.setLength(CUtilJsonInteger.fromJson((CJsonObject)jo, (String)KEY_LENGTH, (int)0));
            return event;
        }
        return null;
    }

    @NotNull
    public String encode(char @NotNull [] aPassword) {
        this.mHasDigits = false;
        this.mHasCapitalAndSmallLetters = false;
        this.mHasSpecialCharacters = false;
        boolean lowerCase = false;
        boolean upperCase = false;
        for (char c : aPassword) {
            if (Character.isDigit(c)) {
                this.mHasDigits = true;
            }
            if (Character.isLowerCase(c)) {
                lowerCase = true;
            }
            if (Character.isUpperCase(c)) {
                upperCase = true;
            }
            if (Character.isLetterOrDigit(c)) continue;
            this.mHasSpecialCharacters = true;
        }
        this.mHasCapitalAndSmallLetters = lowerCase && upperCase;
        this.mLength = aPassword.length;
        String s = CUtilPassword.hashPassword((char[])aPassword);
        return s == null ? "" : s;
    }

    public String getEncodedPasswordBase64() {
        return this.mEncodedPasswordBase64;
    }

    public boolean isHasCapitalAndSmallLetters() {
        return this.mHasCapitalAndSmallLetters;
    }

    public void setHasCapitalAndSmallLetters(boolean aHasCapitalAndSmallLetters) {
        this.mHasCapitalAndSmallLetters = aHasCapitalAndSmallLetters;
    }

    public boolean isHasSpecialCharacters() {
        return this.mHasSpecialCharacters;
    }

    public void setHasSpecialCharacters(boolean aHasSpecialCharacters) {
        this.mHasSpecialCharacters = aHasSpecialCharacters;
    }

    public boolean isHasDigits() {
        return this.mHasDigits;
    }

    public void setHasDigits(boolean aHasDigits) {
        this.mHasDigits = aHasDigits;
    }

    public int getLength() {
        return this.mLength;
    }

    public void setLength(int aLength) {
        this.mLength = aLength;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (CUtilString.isValid((String)this.mEncodedPasswordBase64)) {
            jo.put(KEY_PASSWORD, (Object)this.mEncodedPasswordBase64);
        }
        if (this.mHasCapitalAndSmallLetters) {
            jo.put(KEY_HAS_CAPITAL, (Object)true);
        }
        if (this.mHasDigits) {
            jo.put(KEY_HAS_DIGITS, (Object)true);
        }
        if (this.mHasSpecialCharacters) {
            jo.put(KEY_HAS_SPECIAL, (Object)true);
        }
        jo.put(KEY_LENGTH, (Object)this.mLength);
        jo.put(KEY_ENCODING, (Object)this.mEncoding);
        return jo;
    }
}

