/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventOnTableCellNotification
implements IRemoteSkinEvent {
    public static final String COLUMN_ID = "columnid";
    public static final String ROW_ID = "rowid";
    public static final String VALUE = "value";
    private final String mColumnId;
    private final String mRowId;
    private final String mValue;

    public CEventOnTableCellNotification(@NotNull String aColumnId, @NotNull String aRowId, @NotNull String aValue) {
        this.mColumnId = aColumnId;
        this.mRowId = aRowId;
        this.mValue = aValue;
    }

    public static CEventOnTableCellNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String columnId = CUtilJsonString.fromJson((CJsonObject)jo, (String)COLUMN_ID, null);
            String rowId = CUtilJsonString.fromJson((CJsonObject)jo, (String)ROW_ID, null);
            if (CUtilString.isValid((String)columnId) && CUtilString.isValid((String)rowId)) {
                String value = CUtilJsonString.fromJson((CJsonObject)jo, (String)VALUE, (String)"");
                return new CEventOnTableCellNotification(columnId, rowId, value);
            }
        }
        return null;
    }

    @NotNull
    public String getColumnId() {
        return this.mColumnId;
    }

    @NotNull
    public String getRowId() {
        return this.mRowId;
    }

    @NotNull
    public String getValue() {
        return this.mValue;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(COLUMN_ID, (Object)this.mColumnId);
        jo.put(ROW_ID, (Object)this.mRowId);
        jo.put(VALUE, (Object)this.mValue);
        return jo;
    }
}

