/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.registry.CMicroServiceConstants;
import de.sillysky.nyssr.file.registry.records.CRecordFileRegistryAddFileInfos;
import de.sillysky.nyssr.file.registry.records.CRecordFileRegistryFileInfo;
import de.sillysky.nyssr.file.registry.records.CRecordFileRegistryGetFileInfo;
import de.sillysky.nyssr.file.registry.records.CRecordFileRegistryGetFilePaths;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreGetFileInfo;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.file.registry.CFileEntry;
import de.sillysky.nyssr.impl.file.registry.CFileEntryList;
import de.sillysky.nyssr.impl.file.registry.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CFileRegistryTarget
extends CTarget
implements IService {
    private final IDependencies mDependencies;
    private final CFileEntryList mFileList = new CFileEntryList();

    CFileRegistryTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordFileStoreGetFileInfo.ID, this::asyncForwardGetFileInfo);
        this.addMessageHandler(CRecordFileRegistryAddFileInfos.ID, this::asyncAddFileInfos);
        this.addMessageHandler(CRecordFileRegistryGetFilePaths.ID, this::asyncGetFilePaths);
        this.addMessageHandler(CRecordFileRegistryGetFileInfo.ID, this::asyncGetFileInfo);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mDependencies.getRecordHelper().addObserver(CRecordNotifyRemoteNodeRemoved.class, (ITarget)this, false);
        this.registerMicroService();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncForwardGetFileInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord record = CRecordFileStoreGetFileInfo.getFile((CRecord)aRecord, null);
        String path = CRecordFileStoreFile.getPath((CRecord)record, null);
        CUtilCheck.checkEmptyString((Object)path, (String)"No path given", (Object[])new Object[0]);
        String hash = CRecordFileStoreFile.getHash((CRecord)record, null);
        Instant timeOfLastModification = CRecordFileStoreFile.getTimeOfLastModification((CRecord)record, null);
        List<CFileEntry> ee = this.findEntry(path, hash, timeOfLastModification);
        if (ee.isEmpty()) {
            aEnvelope.setResult(5, "No matching file found. path=" + path + ", hash=" + hash);
        } else {
            CFileEntry e = ee.get(0);
            aEnvelope.forwardMessage(e.getSourceTarget());
        }
        return true;
    }

    private boolean asyncAddFileInfos(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord[] infos = CRecordFileRegistryAddFileInfos.getFileInfo((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)infos, (String)"Missing file infos", (Object[])new Object[0]);
        for (CRecord info : infos) {
            String path = CRecordFileRegistryFileInfo.getPath((CRecord)info, null);
            String hash = CRecordFileRegistryFileInfo.getHash((CRecord)info, null);
            Instant timeOfLastModification = CRecordFileRegistryFileInfo.getTimeOfLastModification((CRecord)info, null);
            CTargetAddress sourceAddress = CRecordFileRegistryFileInfo.getSourceAddress((CRecord)info, (CTargetAddress)aEnvelope.getSender());
            CFileEntry entry = new CFileEntry(path, hash, timeOfLastModification, sourceAddress);
            this.mFileList.add(entry);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetFilePaths(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String directory = CRecordFileRegistryGetFilePaths.getDirectory((CRecord)aRecord, (String)"");
        String[] filePaths = this.mFileList.getFilePaths(directory);
        CRecordFileRegistryGetFilePaths.setPaths((CRecord)aRecord, (String[])filePaths);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetFileInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String path = CRecordFileRegistryGetFileInfo.getPath((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)path, (String)"Missing path", (Object[])new Object[0]);
        ArrayList<CRecord> records = new ArrayList<CRecord>();
        List<CFileEntry> ee = this.mFileList.getFileInfo(path);
        if (ee != null && !ee.isEmpty()) {
            for (CFileEntry e : ee) {
                CRecord record = CRecordFileStoreFile.create();
                CRecordFileRegistryFileInfo.setPath((CRecord)record, (String)e.getPath());
                CRecordFileRegistryFileInfo.setHash((CRecord)record, (String)e.getHash());
                CRecordFileRegistryFileInfo.setTimeOfLastModification((CRecord)record, (Instant)e.getTimeOfLastModification());
                CRecordFileRegistryFileInfo.setSourceAddress((CRecord)record, (CTargetAddress)e.getSourceTarget());
                records.add(record);
            }
            CRecord[] array = records.toArray(new CRecord[0]);
            CRecordFileRegistryGetFileInfo.setFileInfo((CRecord)aRecord, (CRecord[])array);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress nodeAddress = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
        this.mFileList.notifyRemoteNodeRemoved(nodeAddress);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.createNamespaceAndRegisterTarget();
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
    }

    @NotNull
    private List<CFileEntry> findEntry(@NotNull String aPath, @Nullable String aHash, @Nullable Instant aTimeOfLastModification) {
        List<CFileEntry> ee = aTimeOfLastModification == null ? (CUtilString.isEmpty((String)aHash) ? this.mFileList.getNewestEntries(aPath) : this.mFileList.getEntries(aPath, aHash)) : (CUtilString.isEmpty((String)aHash) ? this.mFileList.getEntries(aPath, aTimeOfLastModification) : this.mFileList.getEntries(aPath, aHash, aTimeOfLastModification));
        return ee;
    }

    private void createNamespaceAndRegisterTarget() throws CException {
        IId nid = CIdFactory.random((String)"FileTransfer");
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "FileTransfer");
        ITargetRegistry targetRegistry = ns.getTargetRegistry();
        IId tid = CIdFactory.fromObject((Object)"FileRegistry");
        targetRegistry.registerTarget((ITarget)this, tid);
    }

    private void registerMicroService() throws CException {
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CMicroServiceConstants.MICRO_SERVICE_ID, "A registry for files and directories", new ArrayList(), CIdFactory.random(), this.getAddress());
    }
}

