/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.file.registry.CFileEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CFileEntryList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CFileEntryList.class);
    private final Map<String, List<CFileEntry>> mFiles = new HashMap<String, List<CFileEntry>>();

    CFileEntryList() {
    }

    void add(@NotNull CFileEntry aFileEntry) {
        String path = aFileEntry.getPath();
        List<CFileEntry> ee = this.mFiles.get(path = CUtilPath.normalizeSlashesInPath((String)path));
        if (ee == null) {
            ee = new ArrayList<CFileEntry>();
            this.mFiles.put(path, ee);
        }
        ee.add(aFileEntry);
    }

    void remove(@NotNull CTargetAddress aTargetAddress) {
        for (List<CFileEntry> entries : this.mFiles.values()) {
            entries.removeIf(entry -> entry.getSourceTarget().equals((Object)aTargetAddress));
        }
    }

    void remove(@NotNull CFileEntry aFileEntry) {
        String path = aFileEntry.getPath();
        List<CFileEntry> entries = this.mFiles.get(path);
        if (entries != null) {
            entries.remove(aFileEntry);
            if (entries.isEmpty()) {
                this.mFiles.remove(aFileEntry.getPath());
            }
        }
    }

    List<CFileEntry> getEntries(@NotNull String aPath, @NotNull Instant aTimeOfLastModification) {
        String path = CUtilPath.normalizeSlashesInPath((String)aPath);
        List<CFileEntry> ee = this.mFiles.get(path);
        if (ee != null) {
            return ee.stream().filter(entry -> entry.isTimeEqual(aTimeOfLastModification)).collect(Collectors.toList());
        }
        return null;
    }

    public List<CFileEntry> getEntries(@NotNull String aPath, @NotNull String aHash, @NotNull Instant aTimeOfLastModification) {
        String path = CUtilPath.normalizeSlashesInPath((String)aPath);
        List<CFileEntry> ee = this.mFiles.get(path);
        if (ee != null) {
            return ee.stream().filter(entry -> entry.isHashAndTimeEqual(aHash, aTimeOfLastModification)).collect(Collectors.toList());
        }
        return null;
    }

    public List<CFileEntry> getEntries(@NotNull String aPath, @NotNull String aHash) {
        String path = CUtilPath.normalizeSlashesInPath((String)aPath);
        List<CFileEntry> ee = this.mFiles.get(path);
        if (ee != null) {
            return ee.stream().filter(entry -> entry.isHashEqual(aHash)).collect(Collectors.toList());
        }
        return null;
    }

    public List<CFileEntry> getNewestEntries(@NotNull String aPath) {
        Instant maxTime;
        String path = CUtilPath.normalizeSlashesInPath((String)aPath);
        List<CFileEntry> ee = this.mFiles.get(path);
        if (ee != null && (maxTime = (Instant)ee.stream().max(Comparator.comparing(CFileEntry::getTimeOfLastModification)).map(CFileEntry::getTimeOfLastModification).orElse(null)) != null) {
            return ee.stream().filter(entry -> entry.getTimeOfLastModification().equals(maxTime)).collect(Collectors.toList());
        }
        return null;
    }

    @NotNull
    String[] getFilePaths(@NotNull String aDirectory) {
        int length = aDirectory.length();
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : this.mFiles.keySet()) {
            String tail;
            if (!CUtilString.isEmpty((String)aDirectory) && !path.startsWith(aDirectory) || (tail = path.substring(length)).indexOf(92) > 0 || tail.indexOf(47) > 0) continue;
            paths.add(path);
        }
        return paths.toArray(new String[0]);
    }

    @Nullable
    List<CFileEntry> getFileInfo(@NotNull String aPath) {
        String path = CUtilPath.normalizeSlashesInPath((String)aPath);
        return this.mFiles.get(path);
    }

    void notifyRemoteNodeRemoved(@NotNull CNodeAddress aNodeAddress) {
        int count = 0;
        for (List<CFileEntry> list : this.mFiles.values()) {
            Iterator<CFileEntry> iterator = list.iterator();
            while (iterator.hasNext()) {
                CFileEntry next = iterator.next();
                if (!aNodeAddress.equals((Object)next.getSourceTarget().getNodeAddress())) continue;
                iterator.remove();
                ++count;
            }
        }
        LOG.info("{} files removed from registry because node {} has vanished.", new Object[]{count, aNodeAddress});
    }
}

