/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.database.EDatabaseType;
import de.sillysky.nyssr.database.IH2Database;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.session.manager.CTableRight;
import de.sillysky.nyssr.impl.session.manager.CTableRoleRightRelation;
import de.sillysky.nyssr.impl.session.manager.CTableRoles;
import de.sillysky.nyssr.impl.session.manager.CTableUser;
import de.sillysky.nyssr.impl.session.manager.CTableUserRoleRelation;
import de.sillysky.nyssr.impl.session.manager.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CUserDb {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"session");
    private final IDependencies mDependencies;
    private IH2Database mDatabase;
    private CTableUser mTableUser;
    private CTableRoles mTableRole;
    private CTableRight mTableRight;
    private CTableUserRoleRelation mTableUserRole;
    private CTableRoleRightRelation mTableRoleRight;

    CUserDb(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    void activate() throws Exception {
        CStringProperties dbProperties = this.privateGetDbProperties();
        this.createDatabase(dbProperties);
    }

    private void createDatabase(CStringProperties aDbProperties) throws CException {
        this.mDatabase = this.mDependencies.getH2DatabaseFactory().createDatabase(aDbProperties);
        Connection connection = this.mDatabase.getConnection();
        this.mTableUser = new CTableUser(connection, LOG, "User");
        this.mTableRole = new CTableRoles(connection, LOG, "Role");
        this.mTableRight = new CTableRight(connection, LOG, "Right");
        this.mTableUserRole = new CTableUserRoleRelation(connection, LOG, "UserRole");
        this.mTableRoleRight = new CTableRoleRightRelation(connection, LOG, "RoleRight");
    }

    @NotNull
    private CStringProperties privateGetDbProperties() {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("session");
        CStringProperties prop = new CStringProperties();
        this.privateTransferProperty(preferences, prop, "database.storage.path", ".");
        this.privateTransferProperty(preferences, prop, "database.name", "database");
        this.privateTransferProperty(preferences, prop, "database.type", EDatabaseType.MEMORY.name());
        this.privateTransferProperty(preferences, prop, "database.cipher", "");
        this.privateTransferProperty(preferences, prop, "database.user.id", "");
        this.privateTransferProperty(preferences, prop, "database.user.password", "");
        this.privateTransferProperty(preferences, prop, "database.db.password", "");
        return prop;
    }

    private void privateTransferProperty(Preferences aPref, CStringProperties aProp, String aKey, String aDefault) {
        String value = aDefault;
        if (aPref != null) {
            value = aPref.get(aKey, aDefault);
        }
        aProp.put(aKey, value);
    }

    @Nullable
    Collection<String> getRightsForUser(@NotNull String aCurrentUser, @NotNull String aUserId) {
        return this.getRightsForUser(aUserId);
    }

    @Nullable
    private Collection<String> getRightsForUser(@NotNull String aUserId) {
        Collection<String> roles;
        boolean exists = this.mTableUser.exists(aUserId);
        if (exists && !(roles = this.mTableUserRole.getRolesForUser(aUserId)).isEmpty()) {
            return this.mTableRoleRight.getRightsForRoles(roles);
        }
        return null;
    }

    CResult checkForRight(@NotNull String aUserId, @NotNull String aPasswordHashBase64, @NotNull String aRight) {
        boolean success = this.mTableUser.verifyPassword(aUserId, aPasswordHashBase64);
        if (!success) {
            return new CResult(5103).append("Unknown User or Password").log(LOG);
        }
        Collection<String> rights = this.getRightsForUser(aUserId);
        if (rights != null && rights.contains(aRight)) {
            return null;
        }
        return new CResult(5105).append("Missing Right: ").append(aRight).log(LOG);
    }

    @Nullable
    CResult addRole(@NotNull String aCurrentUser, @NotNull String aRoleId, @Nullable String aDescription, boolean aProtected) {
        boolean exists = this.mTableRole.exists(aRoleId);
        if (exists) {
            return new CResult(16, "Role exists: ").append(aRoleId).log(LOG);
        }
        this.mTableRole.add(aRoleId, aDescription == null ? "" : aDescription, aProtected, aCurrentUser);
        return null;
    }

    @Nullable
    CResult addRight(@NotNull String aRightId, @Nullable String aDescription, boolean aProtected) {
        boolean exists = this.mTableRight.exists(aRightId);
        if (exists) {
            return new CResult(16, "Right exists: ").append(aRightId).log(LOG);
        }
        this.mTableRight.add(aRightId, aDescription == null ? "" : aDescription, aProtected);
        return null;
    }

    @Nullable
    CResult addRightToRole(@NotNull String aCurrentUser, @NotNull String aRoleId, @NotNull String aRightId) {
        boolean success = this.mTableRight.exists(aRightId);
        if (!success) {
            return new CResult(5106).append("Unknown Right ").append(aRightId).log(LOG);
        }
        success = this.mTableRole.exists(aRoleId);
        if (!success) {
            return new CResult(5104).append("Unknown Role ").append(aRoleId).log(LOG);
        }
        this.mTableRoleRight.addRightToRole(aCurrentUser, aRoleId, aRightId);
        return null;
    }

    @Nullable
    CResult addUser(@NotNull String aCurrentUser, @NotNull String aUserId, @Nullable String aRealName, @Nullable String aEmail, @Nullable String aPicture, @NotNull String aPasswordHashBase64) {
        boolean exist = this.mTableUser.exists(aUserId);
        if (exist) {
            return new CResult(16, "User exists: ").append(aUserId).log(LOG);
        }
        this.mTableUser.add(aUserId, aRealName == null ? "" : aRealName, aEmail == null ? "" : aEmail, aPicture == null ? "" : aPicture, aCurrentUser, aPasswordHashBase64, true, true);
        return null;
    }

    @Nullable
    CResult removeUser(@NotNull String aCurrentUser, @NotNull String aUserId) {
        this.mTableUserRole.removeUser(aUserId);
        this.mTableUser.removeUser(aUserId);
        return null;
    }

    @Nullable
    CResult removeRole(@NotNull String aCurrentUser, @NotNull String aRoleId) {
        if (!this.mTableRole.exists(aRoleId)) {
            return new CResult(5, "Role not found.");
        }
        if (this.mTableRole.isProtected(aRoleId)) {
            return new CResult(5501, "Role is protected.");
        }
        this.mTableRoleRight.removeRole(aRoleId);
        this.mTableUserRole.removeRole(aRoleId);
        this.mTableRole.remove(aRoleId);
        return null;
    }

    @Nullable
    CResult removeRight(@NotNull String aCurrentUser, @NotNull String aRightId) {
        this.mTableRoleRight.removeRight(aRightId);
        return this.mTableRight.remove(aRightId);
    }

    @Nullable
    CResult removeRightFromRole(@NotNull String aCurrentUser, @NotNull String aRoleId, @NotNull String aRightId) {
        this.mTableRoleRight.removeRightFromRole(aRoleId, aRightId);
        return null;
    }

    @Nullable
    CResult removeUserFromRole(@NotNull String aCurrentUser, @NotNull String aUserId, @NotNull String aRoleId) {
        this.mTableUserRole.removeUserFromRole(aUserId, aRoleId);
        return null;
    }

    int getUserCount() {
        return this.mTableUser.getCount();
    }

    int getRoleCount() {
        return this.mTableRole.getCount();
    }

    int getRightCount() {
        return this.mTableRight.getCount();
    }

    boolean existsUser(@NotNull String aCurrentUser, @NotNull String aPasswordHashBase64, @NotNull String aUserId) {
        CResult result = this.checkForRight(aCurrentUser, aPasswordHashBase64, "NY_VerifyUser");
        if (result != null) {
            return false;
        }
        return this.mTableUser.exists(aUserId);
    }

    boolean existsRole(@NotNull String aCurrentUser, @NotNull String aPasswordHashBase64, @NotNull String aRoleId) {
        CResult result = this.checkForRight(aCurrentUser, aPasswordHashBase64, "NY_VerifyUser");
        if (result != null) {
            return false;
        }
        return this.mTableRole.exists(aRoleId);
    }

    boolean existsRight(@NotNull String aCurrentUser, @NotNull String aPasswordHashBase64, @NotNull String aRightId) {
        CResult result = this.checkForRight(aCurrentUser, aPasswordHashBase64, "NY_VerifyUser");
        if (result != null) {
            return false;
        }
        return this.mTableRight.exists(aRightId);
    }

    @Nullable
    CResult addUserToRole(@NotNull String aCurrentUser, @NotNull String aUserId, @NotNull String aRoleId) {
        this.mTableUserRole.addUserToRole(aUserId, aRoleId);
        return null;
    }

    @Nullable
    Collection<String> getAllRolesForUser(@NotNull String aCurrentUser, @NotNull String aUserId) {
        return this.mTableUserRole.getRolesForUser(aUserId);
    }

    @Nullable
    Collection<String> getUserList(@NotNull String aCurrentUser) {
        return this.mTableUser.getList();
    }

    @Nullable
    Collection<String> getRoleList(@NotNull String aCurrentUser) {
        return this.mTableRole.getList();
    }

    @Nullable
    Collection<String> getRightList(@NotNull String aCurrentUser) {
        return this.mTableRight.getList();
    }

    boolean verifyPassword(@NotNull String aCurrentUser, @NotNull String aUserId, @NotNull String aPasswordHashBase64) {
        return this.mTableUser.verifyPassword(aUserId, aPasswordHashBase64);
    }

    boolean changePassword(@NotNull String aUserId, @NotNull String aCurrentPasswordHashBase64, @NotNull String aNewPasswordHashBase64) {
        return this.mTableUser.changePassword(aUserId, aCurrentPasswordHashBase64, aNewPasswordHashBase64);
    }

    @Nullable
    CUser getUserRecord(@NotNull String aCurrentUser, @NotNull String aUserId) {
        return this.mTableUser.getUserRecord(aUserId);
    }

    @Nullable
    CRole getRoleRecord(@NotNull String aCurrentUser, @NotNull String aRoleId) {
        return this.mTableRole.getRoleRecord(aRoleId);
    }

    @Nullable
    CRight getRightRecord(@NotNull String aCurrentUser, @NotNull String aRightId) {
        return this.mTableRight.getRightRecord(aRightId);
    }

    CResult updateUserData(@NotNull String aCurrentUser, @NotNull CUser aUser) {
        this.mTableUser.updateUserData(aUser);
        return null;
    }

    boolean isProtected(String aRight) {
        return this.mTableRight.isProtected(aRight);
    }

    @NotNull
    public String[] getRightsForRole(@NotNull String aRoleId) {
        List<String> rightsForRole = this.mTableRoleRight.getRightsForRole(aRoleId);
        String[] empty = new String[]{};
        if (rightsForRole == null) {
            return empty;
        }
        return rightsForRole.toArray(empty);
    }

    public CResult updateRoleData(@NotNull String aRoleId, @NotNull String aDescription) {
        this.mTableRole.updateRoleData(aRoleId, aDescription);
        return null;
    }

    public CResult updateRight(@NotNull String aRightId, @NotNull String aDescription) {
        this.mTableRight.updateRight(aRightId, aDescription);
        return null;
    }
}

