/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.session.manager.CSessionEntry;
import de.sillysky.nyssr.impl.session.manager.CSessionList;
import de.sillysky.nyssr.impl.session.manager.CUserDb;
import de.sillysky.nyssr.impl.session.manager.IDependencies;
import de.sillysky.nyssr.impl.session.manager.ILocalService;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionCreateRight;
import de.sillysky.nyssr.login.records.CRecordSessionLogin;
import de.sillysky.nyssr.login.records.CRecordSessionLogout;
import de.sillysky.nyssr.login.records.CRecordSessionManagementAvailable;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.microservice.collector.CMicroServiceInstance;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastSendMsg;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbAddRolesToUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbChangePassword;
import de.sillysky.nyssr.session.api.records.CRecordUserDbCreateRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbCreateUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteRight;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightListForRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRolesForUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetUserRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGrantRightToRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRemoveRolesFromUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRevokeRightFromRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUpdateRight;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUpdateRoleRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUpdateUserRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUserRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.CUtilString;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CSessionManager
extends CTarget
implements IService,
ILocalService {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"session");
    private static final IId TIMER_ID = CIdFactory.fromObject((Object)"MaintenanceTimer");
    private static final long TIMER_DELAY = 60000L;
    private final CSessionList mSessionList;
    private final IDependencies mDependencies;
    private final CUserDb mUserDb;
    private CTimer mMaintenanceTimer = null;
    private int mSessionTimeout;

    CSessionManager(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.mSessionList = new CSessionList(aDependencies, this);
        this.mUserDb = new CUserDb(this.mDependencies);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionLogin.ID, this::asyncSessionLogin);
        this.addMessageHandler(CRecordSessionLogout.ID, this::asyncSessionLogout);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
        this.addMessageHandler(CRecordUserDbGetUserList.ID, this::asyncGetUserList);
        this.addMessageHandler(CRecordUserDbGetUserRecord.ID, this::asyncGetUserRecord);
        this.addMessageHandler(CRecordUserDbUpdateUserRecord.ID, this::asyncUpdateUserData);
        this.addMessageHandler(CRecordUserDbUpdateRoleRecord.ID, this::asyncUpdateRoleRecord);
        this.addMessageHandler(CRecordUserDbUpdateRight.ID, this::asyncUpdateRight);
        this.addMessageHandler(CRecordUserDbGetRoleList.ID, this::asyncGetAllRoles);
        this.addMessageHandler(CRecordUserDbGetRightList.ID, this::asyncGetAllRights);
        this.addMessageHandler(CRecordUserDbAddRolesToUser.ID, this::asyncAddRolesToUser);
        this.addMessageHandler(CRecordUserDbRemoveRolesFromUser.ID, this::asyncRemoveRolesFromUser);
        this.addMessageHandler(CRecordUserDbCreateUser.ID, this::asyncCreateUser);
        this.addMessageHandler(CRecordUserDbDeleteUser.ID, this::asyncDeleteUser);
        this.addMessageHandler(CRecordSessionCreateRight.ID, this::asyncCreateRight);
        this.addMessageHandler(CRecordUserDbDeleteRight.ID, this::asyncDeleteRight);
        this.addMessageHandler(CRecordUserDbGetRoleRecord.ID, this::asyncGetRoleRecord);
        this.addMessageHandler(CRecordUserDbGetRightListForRole.ID, this::asyncGetRightListForRole);
        this.addMessageHandler(CRecordUserDbCreateRole.ID, this::asyncCreateRole);
        this.addMessageHandler(CRecordUserDbDeleteRole.ID, this::asyncDeleteRole);
        this.addMessageHandler(CRecordUserDbGrantRightToRole.ID, this::asyncAddRightToRole);
        this.addMessageHandler(CRecordUserDbRevokeRightFromRole.ID, this::asyncRevokeRight);
        this.addMessageHandler(CRecordUserDbChangePassword.ID, this::asyncChangePassword);
        this.addMessageHandler(CRecordUserDbGetRightRecord.ID, this::asyncGetRightRecord);
        this.addMessageHandler(CRecordUserDbGetRolesForUser.ID, this::asyncGetRolesForUser);
        this.addMessageHandler(TIMER_ID, this::asyncMaintenanceTimer);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        LOG.info("{}: activate module", new Object[]{"SessionManager"});
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Preferences preferences = kc.getPreferences("session");
        this.mSessionTimeout = preferences.getInt("timeout_in_minutes", 30);
        IId id = CIdFactory.fromObject((Object)"Session");
        INamespace namespace = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(id, "SessionManager");
        namespace.getTargetRegistry().registerTarget((ITarget)this, id);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        LOG.info("{}: deactivate module", new Object[]{"SessionManager"});
        this.privateRemoveMicroService();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws Exception {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mUserDb.activate();
        this.privateAddMicroService();
        this.broadcastSessionAvailable();
        this.mMaintenanceTimer = new CTimer(this.mDependencies.getTimerManager(), TIMER_ID, this.getAddress(), 60000L, false, null);
        this.mMaintenanceTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionLogin(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String userId = CRecordSessionLogin.getUserId((CRecord)aRecord, null);
        String password = CRecordSessionLogin.getPassword((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyString((Object)userId, (String)"Missing User ID", (Object[])new Object[0]);
        LOG.debug("Got Session LogIn: userId = {}", new Object[]{userId});
        boolean success = this.mUserDb.verifyPassword("guest", userId, password);
        if (success) {
            LOG.info("{}: successfully User {} verified", new Object[]{"SessionManager", userId});
            ArrayList rights = this.mUserDb.getRightsForUser("guest", userId);
            String token = this.add(userId, rights == null ? new ArrayList() : rights);
            CRecordSessionLogin.setToken((CRecord)aRecord, (String)token);
            aEnvelope.setResultSuccess();
        } else {
            LOG.error("{}: Error on verifying User {}", new Object[]{"SessionManager", userId});
            aEnvelope.setResult(5103, "Unknown User Or Password");
        }
        return true;
    }

    private boolean asyncSessionLogout(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String token = CRecordSessionValidate.getToken((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)token, (String)"Token is unknown", (Object[])new Object[0]);
        String userId = this.getUserId(token);
        CUtilCheck.checkEmptyString((Object)userId, (String)"Token is unknown", (Object[])new Object[0]);
        this.remove(token);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String token = CRecordSessionValidate.getToken((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)token, (String)"Token is unknown", (Object[])new Object[0]);
        String userId = this.getUserId(token);
        CUtilCheck.checkEmptyString((Object)userId, (String)"Token is unknown", (Object[])new Object[0]);
        Collection<String> rights = this.getRights(token);
        CRecordSessionValidate.setUserId((CRecord)aRecord, (String)userId);
        CRecordSessionValidate.setRights((CRecord)aRecord, (String[])rights.toArray(new String[0]));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetUserList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetUserList")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetUserList");
            return true;
        }
        Collection<String> userList = this.mUserDb.getUserList(sessionEntry.getUserId());
        if (userList == null) {
            aEnvelope.setResult(5105, "Missing Rights");
            return true;
        }
        CRecordUserDbGetUserList.setUserIds((CRecord)aRecord, (String[])userList.toArray(new String[0]));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetAllRoles(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetListOfRoles")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetListOfRoles");
            return true;
        }
        Collection<String> roleList = this.mUserDb.getRoleList(sessionEntry.getUserId());
        if (roleList == null) {
            aEnvelope.setResult(5105, "Missing Rights");
            return true;
        }
        CRecordUserDbGetRoleList.setRoles((CRecord)aRecord, (String[])roleList.toArray(new String[0]));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetAllRights(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetRightList")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetRightList");
            return true;
        }
        Collection<String> rightList = this.mUserDb.getRightList(sessionEntry.getUserId());
        if (rightList == null) {
            aEnvelope.setResult(5105, "Missing Rights");
            return true;
        }
        CRecordUserDbGetRightList.setRights((CRecord)aRecord, (String[])rightList.toArray(new String[0]));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetUserRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetUserData")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetUserData");
            return true;
        }
        String requesterId = sessionEntry.getUserId();
        String userId = CRecordUserDbGetUserRecord.getUserId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)userId, (String)"Missing UserId", (Object[])new Object[0]);
        CUser user = this.mUserDb.getUserRecord(requesterId, userId);
        if (user == null) {
            aEnvelope.setResult(5, "User not found: " + userId);
        } else {
            Collection<String> rights;
            CRecord rec = CRecordUserDbUserRecord.create();
            CRecordUserDbUserRecord.setUserId((CRecord)rec, (String)user.getId());
            CRecordUserDbUserRecord.setRealName((CRecord)rec, (String)user.getRealName());
            CRecordUserDbUserRecord.setEmail((CRecord)rec, (String)user.getEmail());
            CRecordUserDbUserRecord.setPicture((CRecord)rec, (String)user.getPicture());
            CRecordUserDbUserRecord.setCreatedBy((CRecord)rec, (String)user.getCreatedByUser());
            CRecordUserDbUserRecord.setTimeCreated((CRecord)rec, (LocalDateTime)user.getTimeCreated());
            CRecordUserDbGetUserRecord.setUser((CRecord)aRecord, (CRecord)rec);
            Collection<String> allRolesForUser = this.mUserDb.getAllRolesForUser(requesterId, userId);
            if (allRolesForUser != null && !allRolesForUser.isEmpty()) {
                String[] arr = allRolesForUser.toArray(new String[0]);
                CRecordUserDbGetUserRecord.setRoles((CRecord)aRecord, (String[])arr);
            }
            if ((rights = this.mUserDb.getRightsForUser(requesterId, userId)) != null && !rights.isEmpty()) {
                String[] arr = rights.toArray(new String[0]);
                CRecordUserDbGetUserRecord.setRights((CRecord)aRecord, (String[])arr);
            }
            aEnvelope.setResultSuccess();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRolesForUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetUserData")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetUserData");
            return true;
        }
        String userId = CRecordUserDbGetRolesForUser.getUserId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)userId, (String)"Missing UserId", (Object[])new Object[0]);
        String requesterId = sessionEntry.getUserId();
        Collection<String> roles = this.mUserDb.getAllRolesForUser(requesterId, userId);
        if (roles != null && !roles.isEmpty()) {
            String[] arr = roles.toArray(new String[0]);
            CRecordUserDbGetRolesForUser.setRoles((CRecord)aRecord, (String[])arr);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRoleRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetRoleData")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetRoleData");
            return true;
        }
        String requesterId = sessionEntry.getUserId();
        String roleId = CRecordUserDbGetRoleRecord.getRoleId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)roleId, (String)"Missing RoleId", (Object[])new Object[0]);
        CRole role = this.mUserDb.getRoleRecord(requesterId, roleId);
        if (role == null) {
            aEnvelope.setResult(5, "User not found: " + roleId);
            aEnvelope.setResult(5, "Not found");
        } else {
            CRecord rec = role.toRecord();
            CRecordUserDbGetRoleRecord.setRoleRecord((CRecord)aRecord, (CRecord)rec);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncGetRightRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetRightData")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetRightData");
            return true;
        }
        String requesterId = sessionEntry.getUserId();
        String rightId = CRecordUserDbGetRightRecord.getRightId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)rightId, (String)"Missing RightId", (Object[])new Object[0]);
        CRight right = this.mUserDb.getRightRecord(requesterId, rightId);
        if (right == null) {
            aEnvelope.setResult(5, "User not found: " + rightId);
            aEnvelope.setResult(5, "Not found");
        } else {
            CRecordUserDbGetRightRecord.setDescription((CRecord)aRecord, (String)right.getDescription());
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncUpdateUserData(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String userId;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        String requesterId = sessionEntry.getUserId();
        if (!requesterId.equals(userId = CRecordUserDbUpdateUserRecord.getUserId((CRecord)aRecord, (String)"")) && !sessionEntry.hasRight("NY_UpdateUser")) {
            aEnvelope.setResult(5105, "Missing Right NY_UpdateUser");
            return true;
        }
        String realName = CRecordUserDbUpdateUserRecord.getRealName((CRecord)aRecord, (String)"");
        String email = CRecordUserDbUpdateUserRecord.getEmail((CRecord)aRecord, (String)"");
        String picture = CRecordUserDbUpdateUserRecord.getPicture((CRecord)aRecord, (String)"");
        CResult result = this.mUserDb.updateUserData(requesterId, new CUser(userId, realName, email, picture));
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncUpdateRoleRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        String roleId = CRecordUserDbUpdateRoleRecord.getRoleId((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyStringEx((Object)roleId, (String)"Missing roleId", (Object[])new Object[0]);
        String description = CRecordUserDbUpdateRoleRecord.getDescription((CRecord)aRecord, (String)"");
        CResult result = this.mUserDb.updateRoleData(roleId, description);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncUpdateRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        String rightId = CRecordUserDbUpdateRight.getRightId((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyStringEx((Object)rightId, (String)"Missing right ID", (Object[])new Object[0]);
        String description = CRecordUserDbUpdateRight.getDescription((CRecord)aRecord, (String)"");
        CResult result = this.mUserDb.updateRight(rightId, description);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRightListForRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GetRightList")) {
            aEnvelope.setResult(5105, "Missing Right NY_GetRightList");
            return true;
        }
        String roleId = CRecordUserDbGetRightListForRole.getRoleId((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyString((Object)roleId, (String)"Missing role ID", (Object[])new Object[0]);
        String[] rights = this.mUserDb.getRightsForRole(roleId);
        CRecordUserDbGetRightListForRole.setRights((CRecord)aRecord, (String[])rights);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddRolesToUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_AddRoleToUser")) {
            aEnvelope.setResult(5105, "Missing Right NY_AddRoleToUser");
            return true;
        }
        String requesterId = sessionEntry.getUserId();
        String userId = CRecordUserDbAddRolesToUser.getUserId((CRecord)aRecord, (String)"");
        CUtilCheck.checkNotNull((Object)userId, (String)"Missing UserId", (Object[])new Object[0]);
        String[] roles = CRecordUserDbAddRolesToUser.getRoles((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)roles, (String)"Missing roles", (Object[])new Object[0]);
        CUtilCheck.checkTrue((roles.length > 0 ? 1 : 0) != 0, (String)"Missing roles", (Object[])new Object[0]);
        CResult result = null;
        for (String role : roles) {
            CResult r = this.mUserDb.addUserToRole(requesterId, userId, role);
            if (r == null) continue;
            result = r;
        }
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncRemoveRolesFromUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_RemoveRoleFromUser")) {
            aEnvelope.setResult(5105, "Missing Right NY_RemoveRoleFromUser");
            return true;
        }
        String requesterId = sessionEntry.getUserId();
        String userId = CRecordUserDbRemoveRolesFromUser.getUserId((CRecord)aRecord, (String)"");
        CUtilCheck.checkNotNull((Object)userId, (String)"Missing UserId", (Object[])new Object[0]);
        String[] roles = CRecordUserDbRemoveRolesFromUser.getRoles((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)roles, (String)"Missing roles", (Object[])new Object[0]);
        CUtilCheck.checkTrue((roles.length > 0 ? 1 : 0) != 0, (String)"Missing roles", (Object[])new Object[0]);
        CResult result = null;
        for (String role : roles) {
            CResult r = this.mUserDb.removeUserFromRole(requesterId, userId, role);
            if (r == null) continue;
            result = r;
        }
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncCreateUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_CreateUser")) {
            aEnvelope.setResult(5105, "Missing Right NY_CreateUser");
            return true;
        }
        String userId = CRecordUserDbCreateUser.getUserId((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyStringEx((Object)userId, (String)"User ID is empty.", (Object[])new Object[0]);
        CUtilCheck.checkTrue((!userId.contains(" ") ? 1 : 0) != 0, (String)"User ID must not contain space.", (Object[])new Object[0]);
        String realName = CRecordUserDbCreateUser.getRealName((CRecord)aRecord, (String)"");
        String email = CRecordUserDbCreateUser.getEmail((CRecord)aRecord, (String)"");
        String picture = CRecordUserDbCreateUser.getPicture((CRecord)aRecord, (String)"");
        String pw = CRecordUserDbCreateUser.getPassword((CRecord)aRecord, (String)"");
        CResult result = this.mUserDb.addUser(sessionEntry.getUserId(), userId, realName, email, picture, pw);
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncCreateRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String right = CRecordSessionCreateRight.getRight((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyString((Object)right, (String)"Missing Right", (Object[])new Object[0]);
        String description = CRecordSessionCreateRight.getDescription((CRecord)aRecord, (String)"");
        boolean isProtected = CRecordSessionCreateRight.getProtected((CRecord)aRecord, (boolean)false);
        CResult result = this.mUserDb.addRight(right, description, isProtected);
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncCreateRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_CreateRole")) {
            aEnvelope.setResult(5105, "Missing right NY_CreateRole");
            return true;
        }
        CRecord record = CRecordUserDbCreateRole.getRoleRecord((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)record, (String)"Missing role record", (Object[])new Object[0]);
        CRole role = new CRole(record);
        String id = role.getId();
        CUtilCheck.checkEmptyStringEx((Object)id, (String)"Role ID is empty.", (Object[])new Object[0]);
        CUtilCheck.checkTrue((!id.contains(" ") ? 1 : 0) != 0, (String)"Role ID must not contain space.", (Object[])new Object[0]);
        CResult result = this.mUserDb.addRole(sessionEntry.getUserId(), id, role.getDescription(), role.isProtected());
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncDeleteRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_DeleteRole")) {
            aEnvelope.setResult(5105, "Missing right NY_DeleteRole");
            return true;
        }
        String roleId = CRecordUserDbDeleteRole.getRoleId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)roleId, (String)"Missing role ID", (Object[])new Object[0]);
        CResult result = this.mUserDb.removeRole(sessionEntry.getUserId(), roleId);
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncAddRightToRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String[] rightArr;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_GrantRight")) {
            aEnvelope.setResult(5105, "Missing right NY_GrantRight");
            return true;
        }
        TreeSet<String> rights = new TreeSet<String>();
        String roleId = CRecordUserDbGrantRightToRole.getRoleId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)roleId, (String)"Missing role ID", (Object[])new Object[0]);
        String rightId = CRecordUserDbGrantRightToRole.getRightId((CRecord)aRecord, null);
        if (rightId != null) {
            rights.add(rightId);
        }
        if ((rightArr = CRecordUserDbGrantRightToRole.getRightIds((CRecord)aRecord, null)) != null) {
            rights.addAll(Arrays.asList(rightArr));
        }
        CUtilCheck.checkTrue((!rights.isEmpty() ? 1 : 0) != 0, (String)"No rights to grant provided", (Object[])new Object[0]);
        CResult result = new CResult();
        for (String right : rights) {
            result = this.mUserDb.addRightToRole(sessionEntry.getUserId(), roleId, right);
        }
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncRevokeRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String[] rightIds;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_RevokeRight")) {
            aEnvelope.setResult(5105, "Missing right NY_RevokeRight");
            return true;
        }
        String roleId = CRecordUserDbRevokeRightFromRole.getRoleId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)roleId, (String)"Missing role ID", (Object[])new Object[0]);
        TreeSet<String> rights = new TreeSet<String>();
        String rightId = CRecordUserDbRevokeRightFromRole.getRightId((CRecord)aRecord, null);
        if (CUtilString.isValid((String)rightId)) {
            rights.add(rightId);
        }
        if ((rightIds = CRecordUserDbRevokeRightFromRole.getRightIds((CRecord)aRecord, null)) != null) {
            rights.addAll(Arrays.asList(rightIds));
        }
        CUtilCheck.checkTrue((!rights.isEmpty() ? 1 : 0) != 0, (String)"No rights to revoke provided", (Object[])new Object[0]);
        CResult result = new CResult();
        for (String right : rights) {
            result = this.mUserDb.removeRightFromRole(sessionEntry.getUserId(), roleId, right);
        }
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncChangePassword(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String userId = CRecordUserDbChangePassword.getUserId((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)userId, (String)"Missing user id", (Object[])new Object[0]);
        String currPw = CRecordUserDbChangePassword.getCurrentPassword((CRecord)aRecord, null);
        String newPw = CRecordUserDbChangePassword.getNewPassword((CRecord)aRecord, null);
        boolean result = this.mUserDb.changePassword(userId, currPw, newPw);
        if (result) {
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(5103, "Unknown user or wrong password");
        }
        return true;
    }

    private boolean asyncDeleteRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_DeleteRight")) {
            aEnvelope.setResult(5105, "Missing Right NY_DeleteRight");
            return true;
        }
        String right = CRecordUserDbDeleteRight.getRight((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyString((Object)right, (String)"Missing Right", (Object[])new Object[0]);
        if (this.mUserDb.isProtected(right)) {
            aEnvelope.setResult(5501, "Right is protected.");
        } else {
            CResult result = this.mUserDb.removeRight(sessionEntry.getUserId(), right);
            aEnvelope.setResult(result);
        }
        return true;
    }

    private boolean asyncDeleteUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSessionEntry sessionEntry = this.checkSessionToken(aRecord);
        if (!sessionEntry.hasRight("NY_DeleteUser")) {
            aEnvelope.setResult(5105, "Missing Right NY_DeleteUser");
            return true;
        }
        String userId = CRecordUserDbDeleteUser.getUserId((CRecord)aRecord, (String)"");
        CUtilCheck.checkNotNull((Object)userId, (String)"Missing UserId", (Object[])new Object[0]);
        CResult result = this.mUserDb.removeUser(sessionEntry.getUserId(), userId);
        aEnvelope.setResult(result);
        return true;
    }

    private boolean asyncMaintenanceTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mMaintenanceTimer.notifyTriggerOccurred();
        this.mSessionList.doMaintenance((ITarget)this);
        this.mMaintenanceTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    @NotNull
    private String add(@NotNull String aUserId, @NotNull Collection<String> aRights) {
        CSessionEntry e = new CSessionEntry(this, aUserId, aRights);
        this.mSessionList.add(e, true);
        String token = e.getToken();
        LOG.info("{}: Add session for {}: {}", new Object[]{"SessionManager", aUserId, token});
        return token;
    }

    @NotNull
    private Collection<String> getRights(@NotNull String aToken) {
        Collection<Object> rights = null;
        LOG.debug("{}: Get rights for token {}", new Object[]{"SessionManager", aToken});
        CSessionEntry e = this.mSessionList.get(aToken);
        if (e != null) {
            rights = this.mUserDb.getRightsForUser("guest", e.getUserId());
            e.notifyActivity();
        }
        return rights == null ? new ArrayList() : rights;
    }

    @Nullable
    private String getUserId(@NotNull String aToken) {
        LOG.debug("{}: Get userId for token {}", new Object[]{"SessionManager", aToken});
        CSessionEntry e = this.mSessionList.get(aToken);
        return e == null ? null : e.getUserId();
    }

    private void remove(@NotNull String aToken) {
        LOG.info("{}: Remove token {}", new Object[]{"SessionManager", aToken});
        this.mSessionList.remove(aToken);
    }

    private void privateAddMicroService() throws CException {
        CMicroServiceDescription desc = new CMicroServiceDescription(CConstantsSession.MICRO_SERVICE_ID, "Session Management", new Class[]{CRecordSessionLogin.class, CRecordSessionLogout.class, CRecordSessionValidate.class, CRecordUserDbChangePassword.class, CRecordUserDbCreateRole.class, CRecordUserDbCreateUser.class, CRecordSessionCreateRight.class, CRecordUserDbGetUserList.class, CRecordUserDbGetRoleList.class, CRecordUserDbGetRightList.class, CRecordUserDbRevokeRightFromRole.class, CRecordUserDbGrantRightToRole.class, CRecordUserDbDeleteUser.class, CRecordUserDbDeleteRole.class, CRecordUserDbDeleteRight.class, CRecordUserDbGetUserRecord.class, CRecordUserDbGetRoleRecord.class, CRecordUserDbRemoveRolesFromUser.class, CRecordUserDbAddRolesToUser.class, CRecordUserDbGetRightListForRole.class, CRecordUserDbUpdateUserRecord.class});
        CMicroServiceInstance microService = new CMicroServiceInstance(desc, CIdFactory.random(), this.getAddress());
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(microService);
    }

    private void privateRemoveMicroService() throws CException {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
    }

    @NotNull
    private CSessionEntry checkSessionToken(@NotNull CRecord aRecord) throws CException {
        Object o = aRecord.getValue("SessionToken", CCommonSlotType.STRING, null);
        if (!(o instanceof String)) {
            throw new CException(new CResult(8, "Missing session token"));
        }
        CSessionEntry sessionEntry = this.mSessionList.get((String)o);
        if (sessionEntry == null) {
            throw new CException(new CResult(5108, "Unknown session token"));
        }
        sessionEntry.notifyActivity();
        return sessionEntry;
    }

    private void broadcastSessionAvailable() throws CException {
        CTargetAddress address = this.getAddress();
        CEnvelope env1 = CEnvelope.forLocalNanoService(CRecordSessionManagementAvailable.class);
        CRecord rec1 = CRecordSessionManagementAvailable.create();
        CRecordSessionManagementAvailable.setIsAvailable((CRecord)rec1, (boolean)true);
        CRecordSessionManagementAvailable.setAddress((CRecord)rec1, (CTargetAddress)address);
        CMessage msgPayload = new CMessage(env1, rec1);
        CEnvelope env2 = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)address.getNodeId());
        CRecord rec2 = CRecordBroadcastSendMsg.create();
        CRecordBroadcastSendMsg.setLocally((CRecord)rec2, (boolean)true);
        CRecordBroadcastSendMsg.setMessage((CRecord)rec2, (CMessage)msgPayload);
        this.sendNotification(env2, rec2);
    }

    @Override
    public int getTimeoutInMinutes() {
        return this.mSessionTimeout;
    }
}

