/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.writer.json;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.db.EAccess;
import de.sillysky.nyssr.record.db.IRecordDatabase;
import de.sillysky.nyssr.record.db.IRecordEntry;
import de.sillysky.nyssr.record.db.ISlotRecord;
import de.sillysky.nyssr.record.writer.json.IRecordWriterJson;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.string.builder.CCommaSeparatedList;
import de.sillysky.nyssr.util.string.builder.CStringBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRecordWriterJson
implements IService,
IRecordWriterJson {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordWriterJson.class);

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IRecordWriterJson.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public String getFormattedJson(@NotNull IRecordDatabase aDatabase, @Nullable Collection<String> aRecordIdList) {
        CStringBuilder sb = new CStringBuilder();
        sb.append('{').newLine().inc();
        sb.appendTab().append('\"').append("records").append("\": [").newLine().inc();
        Collection ids = aRecordIdList != null ? aRecordIdList : aDatabase.getRecordIdStrings();
        int max = ids.size();
        int i = 0;
        for (String idString : ids) {
            boolean printColon = i < max - 1;
            IId id = CIdFactory.fromObject((Object)idString);
            IRecordEntry record = aDatabase.getRecord(id);
            this.printRecord(sb, record, printColon);
            ++i;
        }
        sb.dec().appendTab().append(']').newLine().dec();
        sb.append('}').newLine();
        return sb.toString();
    }

    @Override
    public String getUnformattedJson(@NotNull IRecordDatabase aDatabase, @Nullable Collection<String> aRecordIdList) {
        return null;
    }

    private void printRecord(CStringBuilder aSb, IRecordEntry aRecord, boolean aPrintColon) {
        aSb.appendTab().append('{').newLine().inc();
        this.printRecordId(aSb, aRecord);
        this.printRecordName(aSb, aRecord);
        this.printRecordIsNanoService(aSb, aRecord);
        this.printRecordAccess(aSb, aRecord);
        this.printRecordHasOtherSlots(aSb, aRecord);
        this.printRecordNamespaces(aSb, aRecord);
        this.printRecordDescription(aSb, aRecord);
        aSb.appendTab().append('\"').append("slots").append("\": [").newLine().inc();
        int max = aRecord.getSlotCount();
        int i = 0;
        Iterator slots = aRecord.getSlots();
        while (slots.hasNext()) {
            boolean printColon = i < max - 1;
            this.printSlot(aSb, (ISlotRecord)slots.next(), printColon);
            ++i;
        }
        aSb.dec().appendTab().append(']').newLine().dec();
        aSb.appendTab().append('}');
        if (aPrintColon) {
            aSb.append(',');
        }
        aSb.newLine();
    }

    private void printRecordAccess(CStringBuilder aSb, IRecordEntry aRecord) {
        EAccess accessType = aRecord.getAccessType();
        if (accessType != EAccess.PUBLIC) {
            aSb.appendTab().append('\"').append("access").append("\": \"").append(accessType.name()).append("\",").newLine();
        }
    }

    private void printRecordDescription(CStringBuilder aSb, IRecordEntry aRecord) {
        String description = aRecord.getDescription();
        description = description.replaceAll("([\r\n])", " ");
        description = description.replaceAll("\"", "\\\\\"");
        description = description.trim();
        aSb.appendTab().append('\"').append("description").append("\": \"").append(description).append("\",").newLine();
    }

    private void printRecordHasOtherSlots(CStringBuilder aSb, IRecordEntry aRecord) {
        if (aRecord.hasOtherSlots()) {
            aSb.appendTab().append('\"').append("hasOtherSlots").append("\": \"true\",").newLine();
        }
    }

    private void printRecordId(CStringBuilder aSb, IRecordEntry aRecord) {
        aSb.appendTab().append('\"').append("id").append("\": \"").append(aRecord.getId().valueToString()).append("\",").newLine();
    }

    private void printRecordIsNanoService(CStringBuilder aSb, IRecordEntry aRecord) {
        if (aRecord.isNanoService()) {
            aSb.appendTab().append('\"').append("isService").append("\": \"true\",").newLine();
        }
    }

    private void printRecordName(CStringBuilder aSb, IRecordEntry aRecord) {
        aSb.appendTab().append('\"').append("name").append("\": \"").append(aRecord.getName()).append("\",").newLine();
    }

    private void printRecordNamespaces(CStringBuilder aSb, IRecordEntry aRecord) {
        Collection namespaces = aRecord.getNamespaces();
        int max = namespaces.size();
        if (max > 0) {
            CCommaSeparatedList csl = new CCommaSeparatedList();
            csl.addCollection(namespaces);
            aSb.appendTab().append('\"').append("namespaces").append("\": \"").append(csl.toString()).append("\",").newLine();
        }
    }

    private void printSlot(CStringBuilder aSb, ISlotRecord aSlot, boolean aPrintColon) {
        aSb.appendTab().append('{').newLine().inc();
        this.printSlotKey(aSb, aSlot);
        this.printSlotName(aSb, aSlot);
        this.printSlotDirection(aSb, aSlot);
        this.printSlotMandatory(aSb, aSlot);
        this.printSlotDataType(aSb, aSlot);
        this.printSlotDescription(aSb, aSlot);
        aSb.dec().appendTab().append('}');
        if (aPrintColon) {
            aSb.append(',');
        }
        aSb.newLine();
    }

    private void printSlotDataType(CStringBuilder aSb, ISlotRecord aSlot) {
        aSb.appendTab().append('\"').append("type").append("\": \"").append(aSlot.getSlotTypeName()).append("\",").newLine();
    }

    private void printSlotDescription(CStringBuilder aSb, ISlotRecord aSlot) {
        String description = aSlot.getDescription();
        description = description.replaceAll("([\r\n])", " ");
        description = description.replaceAll("\"", "\\\\\"");
        description = description.trim();
        aSb.appendTab().append('\"').append("description").append("\": \"").append(description).append("\"").newLine();
    }

    private void printSlotDirection(CStringBuilder aSb, ISlotRecord aSlot) {
        aSb.appendTab().append('\"').append("direction").append("\": \"").append(aSlot.getTransportDirection().name()).append("\",").newLine();
    }

    private void printSlotKey(CStringBuilder aSb, ISlotRecord aSlot) {
        aSb.appendTab().append('\"').append("key").append("\": \"").append(aSlot.getKey()).append("\",").newLine();
    }

    private void printSlotMandatory(CStringBuilder aSb, ISlotRecord aSlot) {
        aSb.appendTab().append('\"').append("mandatory").append("\": \"").append(Boolean.toString(aSlot.isMandatory())).append("\",").newLine();
    }

    private void printSlotName(CStringBuilder aSb, ISlotRecord aSlot) {
        aSb.appendTab().append('\"').append("name").append("\": \"").append(aSlot.getName()).append("\",").newLine();
    }

    @Override
    public void writeJson(@NotNull IRecordDatabase aDb, @NotNull Path aPath, @Nullable Collection<String> aRecordIdList) throws CException {
        try {
            String text = this.getFormattedJson(aDb, aRecordIdList);
            File file = aPath.toFile();
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            writer.write(text);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "Error writing JSON");
            throw new CException(2105).append((Object)ex);
        }
    }
}

