/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset.editproperty;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.preset.editproperty.CEditPropertyModel;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Color;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CEditPropertyUi {
    private final CEditPropertyModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs602;
    private final CWidgetId mDialog;
    private final CWidgetId mTextFieldKey;
    private final CWidgetId mTextFieldValue;
    private final CWidgetId mButtonOk;
    private final CWidgetId mButtonCancel;

    public CEditPropertyUi(CEditPropertyModel aModel) {
        this.mModel = aModel;
        this.mServerContext = this.mModel.getServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = aModel.getParent().getWidgetSetId().getInstance();
        this.mWs602 = CWidgetSetId.create((String)"@602_EditProperty", (String)instance);
        this.mDialog = CWidgetId.create((String)"#602_Dialog", (CWidgetSetId)this.mWs602);
        this.mApi.addListener(this.mDialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.mTextFieldKey = CWidgetId.create((String)"#602_TextField_Key", (CWidgetSetId)this.mWs602);
        this.mApi.addListener(this.mTextFieldKey, (IListener)((ITextChangeListener)this::onTextChangeKey));
        this.mTextFieldValue = CWidgetId.create((String)"#602_TextField_Value", (CWidgetSetId)this.mWs602);
        this.mApi.addListener(this.mTextFieldValue, (IListener)((ITextChangeListener)this::onTextChangeValue));
        this.mButtonOk = CWidgetId.create((String)"#602_Button_Okay", (CWidgetSetId)this.mWs602);
        this.mApi.addListener(this.mButtonOk, (IListener)((IButtonPressedListener)this::onButtonOkayPressed));
        this.mButtonCancel = CWidgetId.create((String)"#602_Button_Cancel", (CWidgetSetId)this.mWs602);
        this.mApi.addListener(this.mButtonCancel, (IListener)((IButtonPressedListener)this::onButtonCancelPressed));
    }

    private void widgetSet602Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        boolean doCreate = this.mModel.isCreate();
        this.mApi.setTitle(this.mDialog, doCreate ? "New Property" : "Change Property");
        this.mApi.setText(this.mTextFieldKey, this.mModel.getKey());
        this.mApi.setEditable(this.mTextFieldKey, doCreate);
        this.mApi.setForegroundColor(this.mTextFieldKey, doCreate ? new CEventColor(Color.BLACK) : new CEventColor("DimGray", 255));
        this.mApi.setText(this.mTextFieldValue, this.mModel.getValue());
        this.mApi.pack(this.mDialog);
        this.mApi.centerWidget(this.mDialog, this.mModel.getParent());
        this.mApi.setVisible(this.mDialog, true);
        this.enableOkay(true);
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) throws CException {
        this.unmount(false);
    }

    private void onButtonCancelPressed(@NotNull CEventButtonPressedNotification aValues) throws CException {
        this.unmount(false);
    }

    private void onButtonOkayPressed(@NotNull CEventButtonPressedNotification aValues) throws CException {
        this.unmount(true);
    }

    private void onTextChangeKey(@NotNull CEventTextChangeNotification aValues) {
        String text = aValues.getText();
        this.mModel.setKey(text);
        this.enableOkay(true);
    }

    private void onTextChangeValue(@NotNull CEventTextChangeNotification aValues) {
        String text = aValues.getText();
        this.mModel.setValue(text);
        this.enableOkay(true);
    }

    void unmount(boolean aResult) throws CException {
        this.mApi.unmount(this.mDialog);
        this.mServerContext.sendUpdate();
        this.mModel.getTarget().finish(aResult);
    }

    void enableOkay(boolean aUpdate) {
        boolean result = false;
        if (CUtilString.isValid((String)this.mModel.getKey()) && (this.mModel.isCreate() || !Objects.equals(this.mModel.getValue(), this.mModel.getOldValue()))) {
            result = true;
        }
        if (this.mModel.isButtonOkayEnabled() != result) {
            this.mModel.setButtonOkayEnabled(result);
            this.mApi.setEnabled(this.mButtonOk, result);
            if (aUpdate) {
                this.mServerContext.sendUpdate();
            }
        }
    }

    void mountWidgetSet() {
        this.mServerContext.mountWidgetSet(this.mWs602, this.mModel.getParent(), null, this::widgetSet602Mounted);
        this.mServerContext.sendUpdate();
    }
}

