/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.dialog.preset.CConstantsDialogPreset;
import de.sillysky.nyssr.dialog.preset.records.CRecordOpenDialogPreset;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.dialog.preset.CPresetTarget;
import de.sillysky.nyssr.impl.dialog.preset.IDialogPresetDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialogFactory;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class CDialogPresetFactory
extends CBasicDialogFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.preset");
    private final IDialogPresetDependencies mDependencies;

    CDialogPresetFactory(@NotNull IDialogPresetDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Module DialogPreset has been started.");
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordOpenDialogPreset.ID, this::asyncOpenDialogPreset);
        INamespaceFactory namespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        INamespace ns = namespaceFactory.createAndRegisterNamespace(CWellKnownNID.REMOTE_SKIN, "Remote UI");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
        LOG.debug("Module DialogPreset has been removed.");
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.registerMicroService();
        return true;
    }

    private boolean asyncOpenDialogPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CDialogDto dto = this.checkStartDialog(aEnvelope, aRecord);
        LOG.debug("Start Dialog Preset instance for {}.", new Object[]{aEnvelope.getSender()});
        CPresetTarget tgt = new CPresetTarget(this.mDependencies, dto, aRecord);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        this.addDialog(tgt);
        CRecordOpenDialogPreset.setTargetAddress((CRecord)aRecord, (CTargetAddress)tgt.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private void registerMicroService() throws CException {
        ArrayList<CDescriptionOfRecord> nanos = new ArrayList<CDescriptionOfRecord>();
        nanos.add(new CDescriptionOfRecord(CRecordOpenDialogPreset.ID, "Show Dialog"));
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstantsDialogPreset.MICRO_SERVICE_ID, "Preset Dialog", nanos, CNodeId.getLocal().getId(), this.getAddress());
    }

    @NotNull
    protected String getDialogName() {
        return "Preset";
    }

    @NotNull
    protected ILogger getLogger() {
        return LOG;
    }
}

