/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing;

import java.awt.Font;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NotNull;

public class CUtilSwing {
    public static boolean isUiThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public static void executeInUiThread(@NotNull Runnable aRunnable) {
        if (CUtilSwing.isUiThread()) {
            aRunnable.run();
        } else {
            CUtilSwing.executeLater(aRunnable);
        }
    }

    public static void executeLater(@NotNull Runnable aRunnable) {
        SwingUtilities.invokeLater(aRunnable);
    }

    public static void setFontSizeGlobal(int aSize) {
        Enumeration e = UIManager.getDefaults().keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof Font)) continue;
            Font f = (Font)value;
            UIManager.put(key, new FontUIResource(f.getName(), f.getStyle(), aSize));
        }
    }
}

