/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.CUtilString;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CResourceHandler<T> {
    private static final ILogger LOG = CLoggerFactory.getLogger(CResourceHandler.class);
    private List<Closeable> mResources = null;
    private boolean mStarted = false;
    private CResult mError = null;
    private Throwable mThrowable = null;
    private T mResult = null;

    private void addError(Exception aEx) {
        if (this.mError == null) {
            this.mError = new CResult(2);
        }
        this.mError.append(aEx.getClass().getSimpleName());
        this.mError.append(": ");
        this.mError.append(aEx.getMessage());
        for (Throwable cause = aEx.getCause(); cause != null; cause = cause.getCause()) {
            this.mError.append('(');
            this.mError.append(cause.getClass().getSimpleName());
            this.mError.append(": ");
            this.mError.append(cause.getMessage());
            this.mError.append(')');
        }
        this.mError.append(CUtilString.CRLF);
        this.mThrowable = aEx;
    }

    private void close() {
        if (this.mResources != null) {
            for (Closeable resource : this.mResources) {
                try {
                    resource.close();
                }
                catch (IOException | RuntimeException e) {
                    this.addError(e);
                }
            }
        }
    }

    protected abstract T doResourceHandling() throws Exception;

    private void doWork() {
        try {
            this.mResult = this.doResourceHandling();
        }
        catch (Exception e) {
            this.addError(e);
        }
        finally {
            this.close();
        }
    }

    public CResult getErrorResult() {
        return this.mError;
    }

    public T getResult() {
        return this.mResult;
    }

    public Throwable getThrowable() {
        return this.mThrowable;
    }

    public void log() {
        if (this.mError != null) {
            LOG.error(this.mThrowable, "Error in ResourceHandler: {}-{}", this.mError.getCode(), this.mError.getText());
        }
    }

    protected void registerResource(Closeable aResource) {
        if (aResource == null) {
            throw new NullPointerException();
        }
        if (this.mResources == null) {
            this.mResources = new ArrayList<Closeable>();
        }
        this.mResources.add(0, aResource);
    }

    public final CResult run() {
        if (this.mStarted) {
            this.mError = new CResult(4).append("Handler can only be started once.");
        }
        this.mStarted = true;
        this.doWork();
        return this.mError;
    }
}

