/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.notification.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyNamespaceRegistered
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("0c1c694d-9744-440e-a665-0433144ca080");
    public static final String NAME = "NotifyNamespaceRegistered";
    public static final String DESCRIPTION = "Notification that a namespace has been added.";
    public static final String SLOT_NAMESPACE = "NAMESPACE";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId getNamespace(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAMESPACE);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setNamespace(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NAMESPACE, slot);
    }
}

