/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.util.CJsonRecordUtil;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.slot.ISlotFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CSlotRecord
implements ISlot,
ISingleSlotTypeFactory {
    private final CRecord mValue;

    public CSlotRecord() {
        this.mValue = new CRecord(IId.INVALID);
    }

    private CSlotRecord(@NotNull CRecord aValue) {
        this.mValue = aValue;
    }

    @Nullable
    private static CSlotRecord fromObject(@Nullable Object aValue) {
        CSlotRecord result = null;
        if (aValue instanceof CRecord) {
            result = new CSlotRecord((CRecord)aValue);
        } else if (aValue instanceof String) {
            result = null;
        } else if (aValue instanceof List) {
            result = null;
        }
        return result;
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotRecord fromStream(@NotNull DataInput aStream) throws IOException {
        boolean exist = aStream.readBoolean();
        if (!exist) {
            return new CSlotRecord(new CRecord(IId.INVALID));
        }
        CRecord value = CRecord.fromStream(aStream);
        return new CSlotRecord(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotRecord.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CRecord record;
        ISlotFactory slotFactory = CServiceRegistry.getInstance().getService(ISlotFactory.class);
        if (slotFactory != null && (record = CJsonRecordUtil.fromJson(aValue, aByteArrayStore, slotFactory)) != null) {
            return new CSlotRecord(record);
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSlotRecord other = (CSlotRecord)obj;
        return this.mValue.equals(other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CRecord.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        CRecord rec = new CRecord(this.mValue);
        return new CSlotRecord(rec);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.RECORD;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mValue.hashCode();
        return result;
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (aValue == null) {
            return false;
        }
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotRecord.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeBoolean(true);
        this.mValue.toStream(aStream);
    }

    public String toString() {
        return this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return CJsonRecordUtil.toJson(this.mValue, aBinaries);
    }
}

