/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.signal;

import de.sillysky.nyssr.impl.signal.CSignal;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.signal.ISignal;
import de.sillysky.nyssr.signal.ISignalListener;
import de.sillysky.nyssr.signal.ISignalRegistry;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

final class CSignalRegistry
implements ISignalRegistry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSignalRegistry.class);
    private static final int DEFAULT_COUNT = 20;
    private final Map<UUID, Set<ISignalListener>> mListeners;
    private final Map<UUID, ISignal> mLastSignals;
    private final String mName;
    private boolean mVerbose = false;
    private int mCounter = 0;
    private int mOffset = 0;
    private Map<UUID, String> mDebugNames = null;
    private Map<Integer, String> mOffsetStrings = null;

    CSignalRegistry(String aName) {
        this.mName = aName;
        this.mListeners = new HashMap<UUID, Set<ISignalListener>>(20);
        this.mLastSignals = new HashMap<UUID, ISignal>(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(UUID aID, ISignalListener aListener, boolean aTriggerLast) {
        Map<UUID, Object> map = this.mListeners;
        synchronized (map) {
            Set set = this.mListeners.computeIfAbsent(aID, k -> new HashSet());
            set.add(aListener);
        }
        if (aTriggerLast) {
            map = this.mLastSignals;
            synchronized (map) {
                ISignal last = this.mLastSignals.get(aID);
                if (last != null) {
                    try {
                        aListener.incomingSignal(last);
                    }
                    catch (Exception e) {
                        LOG.error(e, "Exception on triggering Signal {}: ", last);
                    }
                }
            }
        }
    }

    private String createOffsetString(int offset) {
        if (offset > 0) {
            char[] array = new char[offset];
            Arrays.fill(array, ' ');
            return new String(array);
        }
        return "";
    }

    @Override
    public ISignal createSignal(UUID aID, Object aKey, Object aData) {
        return new CSignal(aID, aKey, aData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismiss() {
        Map<UUID, Object> map = this.mListeners;
        synchronized (map) {
            this.mListeners.clear();
        }
        map = this.mLastSignals;
        synchronized (map) {
            this.mLastSignals.clear();
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    private String getOffsetString(int aOffset) {
        String result = this.mOffsetStrings.get(aOffset);
        if (result == null) {
            result = this.createOffsetString(aOffset);
            this.mOffsetStrings.put(aOffset, result);
        }
        return result;
    }

    @Override
    public void registerName(UUID aID, String aName) {
        if (this.mDebugNames == null) {
            this.mDebugNames = new HashMap<UUID, String>();
        }
        this.mDebugNames.put(aID, aName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(UUID aID, ISignalListener aListener) {
        Map<UUID, Set<ISignalListener>> map = this.mListeners;
        synchronized (map) {
            Set<ISignalListener> set = this.mListeners.get(aID);
            if (set != null) {
                set.remove(aListener);
            }
        }
    }

    @Override
    public void setVerbose(boolean aVerbose) {
        this.mVerbose = aVerbose;
        if (this.mVerbose) {
            this.mDebugNames = new HashMap<UUID, String>();
            this.mOffsetStrings = new HashMap<Integer, String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal(ISignal aSignal) {
        if (aSignal != null) {
            Map<UUID, Object> map = this.mLastSignals;
            synchronized (map) {
                this.mLastSignals.put(aSignal.getID(), aSignal);
            }
            map = this.mListeners;
            synchronized (map) {
                Set<ISignalListener> set = this.mListeners.get(aSignal.getID());
                if (set != null) {
                    for (ISignalListener l : set) {
                        try {
                            if (this.mVerbose) {
                                String s = this.getOffsetString(this.mOffset);
                                int counter = ++this.mCounter;
                                UUID id = aSignal.getID();
                                String name = this.mDebugNames.get(id);
                                if (name == null) {
                                    name = CUtilUuid.toShortString(id);
                                }
                                LOG.trace("{}-->SIGNAL {}, class={} id={} key={} data={}", s, counter, l.getClass().getSimpleName(), name, aSignal.getKey(), aSignal.getData());
                                this.mOffset += 2;
                                l.incomingSignal(aSignal);
                                this.mOffset -= 2;
                                LOG.trace("{}<--SIGNAL {}", s, counter);
                                continue;
                            }
                            l.incomingSignal(aSignal);
                        }
                        catch (Exception e) {
                            LOG.error(e, "Exception on triggering Signal {}: ", aSignal);
                            if (!this.mVerbose) continue;
                            this.mOffset -= 2;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void signal(UUID aID) {
        this.signal(new CSignal(aID, null, null));
    }

    @Override
    public void signal(UUID aID, Object aKey, Object aData) {
        this.signal(new CSignal(aID, aKey, aData));
    }
}

