/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.database;

import de.sillysky.nyssr.impl.file.store.database.CFileEntry;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFileEntryList {
    private final Map<String, CFileEntry> mEntries = new HashMap<String, CFileEntry>();

    public void add(@NotNull CFileEntry aEntry) {
        this.mEntries.put(aEntry.getHash(), aEntry);
    }

    public CFileEntry remove(@NotNull String aHash) {
        return this.mEntries.remove(aHash);
    }

    @Nullable
    public CFileEntry getByHash(@NotNull String aHash) {
        return this.mEntries.get(aHash);
    }

    @Nullable
    public CFileEntry getByPath(@NotNull String aPath) {
        String path = CUtilPath.normalizeSlashesInPath((String)aPath);
        CFileEntry result = null;
        for (CFileEntry e : this.mEntries.values()) {
            if (!e.getRelativePath().equals(path)) continue;
            FileTime entryTime = e.getTimeOfLastModification();
            if (result != null && entryTime.compareTo(result.getTimeOfLastModification()) >= 0) continue;
            result = e;
        }
        return result;
    }

    public int size() {
        return this.mEntries.size();
    }

    public void traverse(Consumer<CFileEntry> aConsumer) {
        this.mEntries.values().forEach(aConsumer);
    }

    public Iterable<CFileEntry> getFileList() {
        return this.mEntries.values();
    }

    boolean hasUnregisteredFiles() {
        for (CFileEntry fileEntry : this.mEntries.values()) {
            if (fileEntry.isRegistered()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public CFileEntry get(@Nullable String aPath, @Nullable String aHash) {
        if (CUtilString.isValid((String)aHash)) {
            return this.getByHash(aHash);
        }
        if (CUtilString.isValid((String)aPath)) {
            return this.getByPath(aPath);
        }
        return null;
    }
}

