/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.database.CH2Table;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import de.sillysky.nyssr.util.time.CUtilTimestamp;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTableRoles
extends CH2Table {
    protected CTableRoles(@NotNull Connection aConnection, @NotNull ILogger aLogger, @NotNull String aName) {
        super(aConnection, aLogger, aName);
        this.createTable();
    }

    private void createTable() {
        if (!this.existTable("X053_ROLE")) {
            String sql = "CREATE TABLE IF NOT EXISTS X053_ROLE(X053_ROLE_ID VARCHAR not null,X053_DESCRIPTION VARCHAR,X053_TIME_CREATED TIMESTAMP default now() not null,X053_CREATED_BY VARCHAR,X053_PROTECTED BOOLEAN,PRIMARY KEY (X053_ROLE_ID))";
            this.executeUpdate("CREATE TABLE IF NOT EXISTS X053_ROLE(X053_ROLE_ID VARCHAR not null,X053_DESCRIPTION VARCHAR,X053_TIME_CREATED TIMESTAMP default now() not null,X053_CREATED_BY VARCHAR,X053_PROTECTED BOOLEAN,PRIMARY KEY (X053_ROLE_ID))", "createTable", null);
            this.add("User", "Normal Users", true, "admin");
            this.add("Administrator", "Administrators", true, "admin");
            this.add("UserManager", "User Manager", true, "admin");
            this.add("UserVerifier", "User Verifier", true, "admin");
            this.add("UserViewer", "User Viewer", true, "admin");
            this.add("Guests", "Guests", true, "admin");
        }
    }

    void add(@NotNull String aRoleId, @NotNull String aDescription, boolean aProtected, @NotNull String aCreatedBy) {
        String sql = "INSERT INTO X053_ROLE (X053_ROLE_ID,X053_DESCRIPTION,X053_TIME_CREATED,X053_CREATED_BY,X053_PROTECTED) VALUES (?, ?, ?, ?, ?)";
        this.executeUpdate("INSERT INTO X053_ROLE (X053_ROLE_ID,X053_DESCRIPTION,X053_TIME_CREATED,X053_CREATED_BY,X053_PROTECTED) VALUES (?, ?, ?, ?, ?)", "addRole", statement -> {
            statement.setString(1, aRoleId);
            statement.setString(2, aDescription);
            statement.setTimestamp(3, CUtilTimestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.now()));
            statement.setString(4, aCreatedBy);
            statement.setBoolean(5, aProtected);
        });
    }

    void remove(String aRoleId) {
        String sql = "DELETE FROM X053_ROLE WHERE X053_ROLE_ID = ? AND X053_PROTECTED = false";
        this.executeUpdate("DELETE FROM X053_ROLE WHERE X053_ROLE_ID = ? AND X053_PROTECTED = false", "deleteRole", statement -> statement.setString(1, aRoleId));
    }

    void deleteAll() {
        String sql = "DELETE FROM X053_ROLE WHERE X053_PROTECTED = false";
        this.executeUpdate("DELETE FROM X053_ROLE WHERE X053_PROTECTED = false", "deleteAll", null);
    }

    void dump(PrintStream aStream) {
        String sql = "SELECT X053_ROLE_ID, X053_DESCRIPTION, X053_PROTECTED, X053_TIME_CREATED, X053_CREATED_BY FROM X053_ROLE ORDER BY X053_ROLE_ID";
        this.executeQuery("SELECT X053_ROLE_ID, X053_DESCRIPTION, X053_PROTECTED, X053_TIME_CREATED, X053_CREATED_BY FROM X053_ROLE ORDER BY X053_ROLE_ID", "dump", null, rs -> {
            while (rs.next()) {
                aStream.print(rs.getString(1));
                aStream.print(" (");
                aStream.print(rs.getString(2));
                boolean isProtected = rs.getBoolean(3);
                if (isProtected) {
                    aStream.print(", protected");
                } else {
                    aStream.print(", not protected");
                }
                aStream.print(") CREATED ");
                aStream.print(rs.getTimestamp(4));
                aStream.print(" BY ");
                aStream.println(rs.getString(5));
            }
            return null;
        });
    }

    int getCount() {
        String sql = "SELECT COUNT(*) FROM X053_ROLE";
        return (int)this.executeQueryLong("SELECT COUNT(*) FROM X053_ROLE", "getRoleCount", null);
    }

    boolean isProtected(@NotNull String aRoleId) {
        String sql = "SELECT X053_PROTECTED FROM X053_ROLE WHERE X053_ROLE_ID=?";
        Boolean isProtected = (Boolean)this.executeQuery("SELECT X053_PROTECTED FROM X053_ROLE WHERE X053_ROLE_ID=?", "isProtected", statement -> statement.setString(1, aRoleId), rs -> {
            boolean p = false;
            while (rs.next()) {
                p = rs.getBoolean(1);
            }
            return p;
        });
        return Boolean.TRUE.equals(isProtected);
    }

    List<String> getList() {
        String sql = "SELECT X053_ROLE_ID FROM X053_ROLE ORDER BY X053_ROLE_ID";
        return (List)this.executeQuery("SELECT X053_ROLE_ID FROM X053_ROLE ORDER BY X053_ROLE_ID", "getRoles", null, rs -> {
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                String roleId = rs.getString(1);
                result.add(roleId);
            }
            return result;
        });
    }

    boolean exists(@NotNull String aRoleId) {
        String sql = "SELECT COUNT(*) FROM X053_ROLE WHERE X053_ROLE_ID=?";
        long count = this.executeQueryLong("SELECT COUNT(*) FROM X053_ROLE WHERE X053_ROLE_ID=?", "roleExists", statement -> statement.setString(1, aRoleId));
        return count == 1L;
    }

    @Nullable
    public CRole getRoleRecord(@NotNull String aRoleId) {
        String sql = "SELECT X053_ROLE_ID,X053_DESCRIPTION,X053_PROTECTED,X053_TIME_CREATED,X053_CREATED_BY FROM X053_ROLE WHERE X053_ROLE_ID=?";
        return (CRole)this.executeQuery("SELECT X053_ROLE_ID,X053_DESCRIPTION,X053_PROTECTED,X053_TIME_CREATED,X053_CREATED_BY FROM X053_ROLE WHERE X053_ROLE_ID=?", "getRoleRecord", statement -> statement.setString(1, aRoleId), rs -> {
            if (rs.next()) {
                String roleId = rs.getString(1);
                String description = rs.getString(2);
                boolean isProtected = rs.getBoolean(3);
                Timestamp ts = rs.getTimestamp(4);
                String createdBy = rs.getString(5);
                LocalDateTime ldt = CUtilLocalDateTime.fromTimestamp((Timestamp)ts);
                return new CRole(roleId, description, isProtected, createdBy, ldt);
            }
            return null;
        });
    }

    public void updateRoleData(String aRoleId, String aDescription) {
        String sql = "UPDATE X053_ROLE SET X053_DESCRIPTION = ? WHERE X053_ROLE_ID=?";
        this.executeUpdate("UPDATE X053_ROLE SET X053_DESCRIPTION = ? WHERE X053_ROLE_ID=?", "updateRoleData", statement -> {
            statement.setString(1, aDescription);
            statement.setString(2, aRoleId);
        });
    }
}

