/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.session.manager.CSessionEntry;
import de.sillysky.nyssr.impl.session.manager.IDependencies;
import de.sillysky.nyssr.impl.session.manager.ILocalService;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionExpired;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.crypt.CUtilAes;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CSessionList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSessionList.class);
    private final Map<String, CSessionEntry> mSessions = new ConcurrentHashMap<String, CSessionEntry>();
    private final IDependencies mDependencies;
    private final ILocalService mLocalService;

    CSessionList(@NotNull IDependencies aDependencies, @NotNull ILocalService aLocalService) {
        this.mDependencies = aDependencies;
        this.mLocalService = aLocalService;
        try {
            this.readFromStorage();
        }
        catch (CException aE) {
            LOG.error("Error reading session tokens", new Object[]{aE});
        }
    }

    void add(@NotNull CSessionEntry aSession, boolean aWriteStorage) {
        this.mSessions.put(aSession.getToken(), aSession);
        if (aWriteStorage) {
            try {
                this.writeToStorage();
            }
            catch (CException aE) {
                LOG.error("Error writing session tokens", new Object[]{aE});
            }
        }
    }

    CSessionEntry remove(@NotNull String aToken) {
        return this.mSessions.remove(aToken);
    }

    CSessionEntry get(@Nullable String aToken) {
        return aToken == null ? null : this.mSessions.get(aToken);
    }

    public String toString() {
        return "[SessionList: " + this.mSessions.size() + " entries]";
    }

    void doMaintenance(@NotNull ITarget aTarget) {
        this.mSessions.values().removeIf(session -> this.isSessionExpired((CSessionEntry)session, aTarget));
    }

    private boolean isSessionExpired(@NotNull CSessionEntry aSession, @NotNull ITarget aTarget) {
        boolean expired = aSession.isExpired();
        if (expired) {
            LOG.debug("Session expired: {}", new Object[]{aSession.getToken()});
            this.sendSessionExpiredNotification(aSession, aTarget.getAddress());
        }
        return expired;
    }

    private void sendSessionExpiredNotification(@NotNull CSessionEntry aSession, @NotNull CTargetAddress aSender) {
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordSessionExpired.class);
            env.setSender(aSender);
            CRecord record = CRecordSessionExpired.create();
            CRecordSessionExpired.setSessionToken((CRecord)record, (String)aSession.getToken());
            this.mDependencies.getBroadcastService().broadcastMessage(env, record, true);
        }
        catch (CException aException) {
            LOG.error((Throwable)aException);
        }
    }

    @Nullable
    private SecretKey getSecretKey() {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("session");
        String s = preferences.get("aes", null);
        if (s != null) {
            byte[] ss = CUtilBase64.decode((String)s);
            return new SecretKeySpec(ss, 0, ss.length, "AES");
        }
        return null;
    }

    @Nullable
    private File getStorageFile() {
        File result = null;
        Path storagePath = this.mDependencies.getKernelConfiguration().getStoragePath();
        if (storagePath != null) {
            Path sessionPath = storagePath.resolve("session");
            sessionPath.toFile().mkdirs();
            Path path = sessionPath.resolve("session.aes");
            result = path.toFile();
        }
        return result;
    }

    private void writeToStorage() throws CException {
        File file;
        SecretKey secretKey = this.getSecretKey();
        if (secretKey != null && (file = this.getStorageFile()) != null) {
            try (ByteArrayOutputStream baOs = new ByteArrayOutputStream();
                 DataOutputStream dos = new DataOutputStream(baOs);){
                CUtilInteger.toStream((DataOutput)dos, (int)this.mSessions.size());
                for (CSessionEntry value : this.mSessions.values()) {
                    value.toStream(dos);
                }
                baOs.flush();
                byte[] bytes = baOs.toByteArray();
                byte[] packed = CUtilAes.pack((SecretKey)secretKey, (byte[])bytes);
                try (FileOutputStream fos = new FileOutputStream(file);
                     DataOutputStream dos2 = new DataOutputStream(fos);){
                    dos2.write(packed);
                }
            }
            catch (Exception aE) {
                throw new CException((Throwable)aE);
            }
        }
    }

    private void readFromStorage() throws CException {
        File file;
        SecretKey secretKey = this.getSecretKey();
        if (secretKey != null && (file = this.getStorageFile()) != null && file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);
                 ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                byte[] fileContent = bos.toByteArray();
                byte[] unpacked = CUtilAes.unpack((SecretKey)secretKey, (byte[])fileContent);
                try (ByteArrayInputStream baIn = new ByteArrayInputStream(unpacked);
                     DataInputStream dis = new DataInputStream(baIn);){
                    int count = CUtilInteger.fromStream((DataInput)dis);
                    for (int i = 0; i < count; ++i) {
                        CSessionEntry entry = CSessionEntry.fromStream(this.mLocalService, dis);
                        if (entry.isExpired()) continue;
                        this.add(entry, false);
                    }
                }
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException aE) {
                throw new CException((Throwable)aE);
            }
        }
    }
}

