/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.database.example;

import de.sillysky.nyssr.database.EDatabaseType;
import de.sillysky.nyssr.database.IH2Database;
import de.sillysky.nyssr.database.IH2DatabaseFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;

public class CH2Example
implements IService {
    private IH2Database mDatabase;
    private Connection mConnection;

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IH2DatabaseFactory.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IH2DatabaseFactory databaseFactory = (IH2DatabaseFactory)aServiceRegistry.getService(IH2DatabaseFactory.class);
        assert (databaseFactory != null);
        Path path = Paths.get(".", new String[0]);
        CStringProperties properties = new CStringProperties();
        properties.put("database.storage.path", path.toString());
        properties.put("database.type", EDatabaseType.EMBEDDED.name());
        properties.put("database.name", "configuration");
        this.mDatabase = databaseFactory.createDatabase(properties);
        this.mConnection = this.mDatabase.getConnection();
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
    }
}

