/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRightRecord;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CRight {
    private String mId;
    private String mDescription;
    private final boolean mProtected;

    public CRight(@NotNull String aId, @NotNull String aDescription, boolean aProtected) {
        this.mId = aId;
        this.mDescription = aDescription;
        this.mProtected = aProtected;
    }

    public CRight() {
        this.mId = "";
        this.mDescription = "";
        this.mProtected = false;
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    public boolean isProtected() {
        return this.mProtected;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CRight right = (CRight)aO;
        return this.mId.equals(right.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public void setId(@NotNull String aRightId) {
        this.mId = aRightId;
    }

    public void setDescription(@NotNull String aDescription) {
        this.mDescription = aDescription;
    }

    @NotNull
    public CRecord toRecord() throws CException {
        CRecord record = CRecordUserDbRightRecord.create();
        CRecordUserDbRightRecord.setRightId(record, this.mId);
        CRecordUserDbRightRecord.setDescription(record, this.mDescription);
        CRecordUserDbRightRecord.setIsProtected(record, this.mProtected);
        return record;
    }
}

